% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_stata_labels.R
\name{replace_stata_labels}
\alias{replace_stata_labels}
\title{Replace Stata Labels}
\usage{
replace_stata_labels(
  data,
  df_new_labels,
  var_name_col = "name",
  var_label_col = "vallab_full",
  trim = c("both", "all"),
  overwrite = TRUE
)
}
\arguments{
\item{data}{data frame for which labels will be replaced}

\item{df_new_labels}{a data frame with a var_name_col and a var_label_col}

\item{var_name_col, var_label_col}{variable names (as strings) for the lookup of variable names in data, and the corresponding variable label.}

\item{trim}{string, trim "both" sides (default), "left" or "right".}

\item{overwrite}{Flag. Whether to remove label if it already exists.}
}
\value{
data, with variable labels replaced
}
\description{
If no replacement exists, keeps the original.
}
