% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_height_h_barchart.R
\name{fig_height_h_barchart}
\alias{fig_height_h_barchart}
\title{Estimate figure height for a horizontal bar chart}
\usage{
fig_height_h_barchart(
  n_y,
  n_cats_y,
  max_chars_y,
  n_x = NULL,
  n_cats_x = NULL,
  max_chars_x = NULL,
  freq = FALSE,
  x_axis_label_width = 20,
  strip_angle = 0,
  main_font_size = 7,
  legend_location = c("plot", "panel"),
  n_legend_lines = 2,
  legend_key_chars_equivalence = 5,
  max_chars_per_figure_width = 100,
  multiplier_per_horizontal_line = NULL,
  multiplier_per_vertical_letter = 1,
  multiplier_per_facet = 1,
  multiplier_per_legend_line = 1,
  fixed_constant = 0,
  figure_width_in_cm = 14,
  margin_in_cm = 0,
  max = 8,
  min = 1
)
}
\arguments{
\item{n_y}{Integer. Number of dependent variables.}

\item{n_cats_y}{Integer. Number of categories across the dependent variables.}

\item{max_chars_y}{Integer. Maximum number of characters across the dependent variables.}

\item{n_x}{Integer. Number of independent variables.}

\item{n_cats_x}{Integer. Number of categories across the independent variables.}

\item{max_chars_x}{Integer. Maximum number of characters across the independent variables.}

\item{freq}{Logical. If TRUE, frequency plot with categories next to each other. If FALSE (default), proportion plot with stacked categories.}

\item{x_axis_label_width}{Numeric. Width allocated for x-axis labels.}

\item{strip_angle}{Integer. Angle of the strip text.}

\item{main_font_size}{Numeric. Font size for the main text.}

\item{legend_location}{Character. Location of the legend ("panel" or "plot").}

\item{n_legend_lines}{Integer. Number of lines in the legend.}

\item{legend_key_chars_equivalence}{Integer. Approximate number of characters the legend key equals.}

\item{max_chars_per_figure_width}{Integer. Maximum number of characters per figure width.}

\item{multiplier_per_horizontal_line}{Numeric. Multiplier per horizontal line.}

\item{multiplier_per_vertical_letter}{Numeric. Multiplier per vertical letter.}

\item{multiplier_per_facet}{Numeric. Multiplier per facet.}

\item{multiplier_per_legend_line}{Numeric. Multiplier per legend line.}

\item{fixed_constant}{Numeric. Fixed constant to be added to the height.}

\item{figure_width_in_cm}{Numeric. Width of the figure in centimeters.}

\item{margin_in_cm}{Numeric. Margin in centimeters.}

\item{max}{Numeric. Maximum height.}

\item{min}{Numeric. Minimum height.}
}
\value{
Numeric value representing the estimated height of the figure.
}
\description{
This function estimates the height of a figure for a horizontal bar chart
based on several parameters including the number of dependent and independent
variables, number of categories, maximum characters in the labels, and
legend properties.
}
\examples{
fig_height_h_barchart(n_y = 5,
                      n_cats_y = 3,
                      max_chars_y = 10,
                      n_x = 2,
                      n_cats_x = 4,
                      max_chars_x = 12,
                      freq = FALSE,
                      x_axis_label_width = 20,
                      strip_angle = 0,
                      main_font_size = 8,
                      legend_location = "panel",
                      n_legend_lines = 2,
                      legend_key_chars_equivalence = 5,
                      max_chars_per_figure_width = 100,
                      multiplier_per_horizontal_line = NULL,
                      multiplier_per_vertical_letter = .15,
                      multiplier_per_facet = .95,
                      multiplier_per_legend_line = 1.5,
                      fixed_constant = 0,
                      figure_width_in_cm = 16,
                      margin_in_cm = 0,
                      max = 8,
                      min = 1)
}
