% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sar_linear.R
\name{sar_linear}
\alias{sar_linear}
\title{Fit the linear model}
\usage{
sar_linear(data, normaTest =  'none', homoTest = 'none', homoCor =
  'spearman', verb = TRUE)
}
\arguments{
\item{data}{A dataset in the form of a dataframe with two columns: the
first with island/site areas, and the second with the species richness
of each island/site.}

\item{normaTest}{The test used to test the normality of the residuals of the
model. Can be any of 'lillie' (Lilliefors Kolmogorov-Smirnov test),
'shapiro' (Shapiro-Wilk test of normality), 'kolmo' (Kolmogorov-Smirnov
test), or 'none' (no residuals normality test is undertaken; the default).}

\item{homoTest}{The test used to check for homogeneity of the residuals of
the model. Can be any of 'cor.fitted' (a correlation of the residuals with
the model fitted values), 'cor.area' (a correlation of the residuals with
the area values), or 'none' (no residuals homogeneity test is undertaken;
the default).}

\item{homoCor}{The correlation test to be used when \code{homoTest !=
"none"}. Can be any of "spearman" (the default), "pearson", or "kendall".}

\item{verb}{Whether or not to print certain warnings (default = TRUE).}
}
\value{
A list of class 'sars' with the following components: 
\itemize{
  \item \strong{par}  The model parameters
  \item \strong{value}  Residual sum of squares
  \item \strong{verge}  Logical code indicating model convergence
  \item \strong{data}  Observed data
  \item \strong{model}  A list of model information (e.g. the model name and formula)
  \item \strong{calculated}   The fitted values of the model
  \item \strong{residuals}  The model residuals
  \item \strong{AIC} The AIC value of the model
  \item \strong{AICc}  The AICc value of the model
  \item \strong{BIC}  The BIC value of the model
  \item \strong{R2}  The R2 value of the model
  \item \strong{R2a} The adjusted R2 value of the model
  \item \strong{sigConf} The model coefficients table
  \item \strong{observed_shape}  The observed shape of the model fit
  \item \strong{asymptote}  A logical value indicating whether the observed fit is asymptotic
  \item \strong{normaTest}  The results of the residuals normality test 
  \item \strong{homoTest}  The results of the residuals homogeneity test
  \item \strong{neg_check}  A logical value indicating whether negative fitted values have been returned}
  The \code{\link{summary.sars}} function returns a more useful summary of
  the model fit results, and the \code{\link{plot.sars}} plots the model
  fit.
}
\description{
Fit the linear model to SAR data.
}
\details{
The model is fitted using linear regression and the
  \code{\link{lm}} function. Model validation can be undertaken by assessing
  the normality (\code{normaTest}) and homogeneity (\code{homoTest}) of
  the residuals and a warning is provided in \code{\link{summary.sars}} if
  either test is chosen and fails.

  A selection of information criteria (e.g. AIC, BIC) are returned and can
  be used to compare models (see also \code{\link{sar_average}}).
}
\examples{
data(galap)
fit <- sar_linear(galap)
summary(fit)
plot(fit)
}
