\name{satinSingle}
\alias{satinSingle}
\title{
 Get a single file satin object from a multiple file object 
}
\description{
 A satin object is obtained from a multiple file object as generated from  \code{\link{satinMGet}} function
}
\usage{
satinSingle(satin.Mobj, file)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{satin.Mobj}{ object generated by \code{\link{satinMGet}} }
  \item{file}{ desired file to be extracted  } 
}
\details{
 When using the \code{\link{satinMGet}} function to process several files, the resulting object has an extra dimension. The \code{satinSingle} function allows to process these objects in the normal way (by \code{\link{satinView}}, for example), by reducing the extra dimension and producing a \code{satin} object 
}
\value{
If \code{itype="avhrr" or itype="oceancolor"}, a satin object with components:
  \item{longitude }{a vector of longitudes of the area of interest (aoi)}
  \item{latitude }{a vector of latitudes of the aoi }
  \item{param }{a matrix of extracted SST or Chl-a values }
  \item{period }{date or averaging period }
  \item{itype }{ a string indicating the type of product }

If \code{itype="quikscat"}, instead of \code{param} matrix the following arrays are returned:
  \item{ucomp}{ tridimensional array of ascending pass, descending  
            pass and  mean  \code{u} components of wind speed } 
  \item{vcomp}{ tridimensional array of ascending pass, descending  
            pass and  mean  \code{v} components of wind speed}
}
\author{ Hctor Villalobos }
\examples{
## Not run:
#  ## get first file from object generated by satinMGet and plot it
#  qsf1 <- satinSingle(multiQS, file = 1)
#  satinView(qsf1)
#
#  ## or direclty in satinView
#  satinView(satinSingle(multiQS, file = 1))
#  
## End (Not run)
}

