#' A sample of European Values Survey (2000) dataset - Hungary
#'
#' This is only a sample dataset for package \code{ggpt} and \code{evs.2000.hun} does not contain
#' all variables from the original dataset available to download from the EVS main site.
#'
#' The data is made of quite a lot of variables, see below. The field work was taken in 1999 in Hungary.
#' The cases represents the Hungarian population (n=1.000) and a weight variable is also given.
#'
#' The included variables were choosen to be able to test the \code{ggpot} package's functions, and
#' mainly includes 'multiple response' and some 'matrix/array type' questions.
#'
#' Theese are answeres to the following  questions:
#' \itemize{
#' 	\item how important in your life: work (Q1A)
#'  \item how important in your life: family (Q1B)
#'  \item how important in your life: friends and acquaintances (Q1C)
#'  \item how important in your life: leisure time (Q1D)
#'  \item how important in your life: politics (Q1E)
#'  \item how important in your life: religion (Q1F)
#'  \item how often discuss politics with friends (Q2)
#'  \item taking all things together how happy are you (Q4)
#'  \item religious service important: birth (Q27A)
#'  \item religious service important: marriage (Q27B)
#'  \item religious service important: death (Q27C)
#'  \item are you a religious person (Q28)
#'  \item do you believe in: God (Q30A)
#'  \item do you believe in: life after death (Q30B)
#'  \item do you believe in: hell (Q30C)
#'  \item do you believe in: heaven (Q30D)
#'  \item do you believe in: sin (Q30E)
#'  \item do you believe in: telepathy (Q30F)
#'  \item do you believe in: reincarnation (Q31)
#'  \item how much confidence in: church (Q58A)
#'  \item how much confidence in: armed forces (Q58B)
#'  \item how much confidence in: education system (Q58C)
#'  \item how much confidence in: the press (Q58D)
#'  \item how much confidence in: trade unions (Q58E)
#'  \item how much confidence in: the police (Q58F)
#'  \item how much confidence in: parliament (Q58G)
#'  \item how much confidence in: civil service (Q58H)
#'  \item how much confidence in: social security system (Q58I)
#'  \item how much confidence in: european union (Q58J)
#'  \item how much confidence in: united nations organisation (Q58L)
#'  \item how much confidence in: health care system (Q58M)
#'  \item how much confidence in: justice system (Q58N)
#'  \item age completed education respondent (Q93)
#' }
#'
#' @title European Values Survey (2000) - Hungary
#' @name evs.2000.hun
#' @format A data frame with 1000 observations and 34 variables.
#' @docType data
#' @references \url{http://www.europeanvaluesstudy.eu/}
#' @keywords data
NULL
