% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_sim.r
\name{gen_stats_table}
\alias{gen_stats_table}
\title{Generate a table of statistics for each model readout.}
\usage{
gen_stats_table(inputdir, outputdir, model, outputfile, xaxis_label = "",
  yaxis_label = "", column_to_read = "X1")
}
\arguments{
\item{inputdir}{the input directory containing the time course files}

\item{outputdir}{the output directory}

\item{model}{the model name}

\item{outputfile}{the name of the file to store the statistics}

\item{xaxis_label}{the label for the x axis (e.g. Time (min))}

\item{yaxis_label}{the label for the y axis (e.g. Level (a.u.))}

\item{column_to_read}{the name of the column to process}
}
\description{
Generate a table of statistics for each model readout.
}
\examples{
data(insulin_receptor_1)
data(insulin_receptor_2)
data(insulin_receptor_3)
dir.create(file.path("sim_datasets"))
write.table(insulin_receptor_1, 
            file=file.path("sim_datasets","insulin_receptor_1.csv"), 
            row.names=FALSE)
write.table(insulin_receptor_2, 
            file=file.path("sim_datasets","insulin_receptor_2.csv"), 
            row.names=FALSE)
write.table(insulin_receptor_3, 
            file=file.path("sim_datasets","insulin_receptor_3.csv"), 
            row.names=FALSE)
gen_stats_table(inputdir="sim_datasets", 
                outputdir="sim_plots", 
                model="insulin_receptor",
                outputfile="insulin_receptor_IR_beta_pY1146_stats.csv", 
                xaxis_label="Time [m]", 
                yaxis_label="Level [a. u.]", 
                column_to_read="IR_beta_pY1146")
}
