% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{Reduction_Loading_Present}
\alias{Reduction_Loading_Present}
\title{Check if reduction loadings are present}
\usage{
Reduction_Loading_Present(
  seurat_object,
  reduction_names,
  print_msg = TRUE,
  omit_warn = TRUE,
  return_none = FALSE
)
}
\arguments{
\item{seurat_object}{object name.}

\item{reduction_names}{vector of genes to check.}

\item{print_msg}{logical. Whether message should be printed if all features are found.  Default is TRUE.}

\item{omit_warn}{logical. Whether to print message about features that are not found in current object.
Default is TRUE.}

\item{return_none}{logical. Whether list of found vs. bad features should still be returned if no
features are found.  Default is FALSE.}
}
\value{
A list of length 3 containing 1) found features, 2) not found features.
}
\description{
Check if reduction loadings are present in object and return vector of found loading names.  Return
warning messages for genes not found.
}
\examples{
\dontrun{
reductions <- Reduction_Loading_Present(seurat_object = obj_name, reduction_name = "PC_1")
found_features <- features[[1]]
}

}
\concept{helper_util}
