% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIGER_Utilities.R
\name{Variable_Features_ALL_LIGER}
\alias{Variable_Features_ALL_LIGER}
\title{Perform variable gene selection over whole dataset}
\usage{
Variable_Features_ALL_LIGER(
  liger_object,
  num_genes = NULL,
  var.thresh = 0.3,
  alpha.thresh = 0.99,
  tol = 1e-04,
  do.plot = FALSE,
  pt.size = 0.3,
  chunk = 1000
)
}
\arguments{
\item{liger_object}{LIGER object name.}

\item{num_genes}{Number of genes to find. Optimizes the value of \code{var.thresh}  to get
this number of genes, (Default is NULL).}

\item{var.thresh}{Variance threshold. Main threshold used to identify variable genes.
Genes with expression variance greater than threshold (relative to mean) are selected.
(higher threshold -> fewer selected genes).}

\item{alpha.thresh}{Alpha threshold. Controls upper bound for expected mean gene
expression (lower threshold -> higher upper bound). (default 0.99)}

\item{tol}{Tolerance to use for optimization if num.genes values passed in (default 0.0001).}

\item{do.plot}{Display log plot of gene variance vs. gene expression. Selected genes are
plotted in green. (Default FALSE)}

\item{pt.size}{Point size for plot.}

\item{chunk}{size of chunks in hdf5 file. (Default 1000)}
}
\value{
A LIGER Object with variable genes in correct slot.
}
\description{
Performs variable gene selection for LIGER object across the entire object instead of by
dataset and then taking union.
}
\examples{
\dontrun{
liger_obj <- Variable_Features_ALL_LIGER(liger_object = liger_obj, num_genes = 2000)
}

}
\references{
Matching function parameter text descriptions are taken from \code{rliger::selectGenes}
which is called by this function after creating new temporary object/dataset.
\url{https://github.com/welch-lab/liger}. (License: GPL-3).
}
\concept{liger_object_util}
