% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generes_to_heatmap.R
\name{generes_to_heatmap}
\alias{generes_to_heatmap}
\title{Generate signature matrix}
\usage{
generes_to_heatmap(
  generes = generes,
  species = "human",
  naming_preference = -9,
  rda_path = "",
  make_names = TRUE,
  internal = FALSE
)
}
\arguments{
\item{generes}{A list of cell-type markers with fold-changes and p-values (FindMarkers output in Seurat).}

\item{species}{The species of gene symbols, if not internal, "human" or "mouse".}

\item{naming_preference}{Likely cell-types given tissues (to be passed into human_mouse_ct_marker_enrich).}

\item{rda_path}{Path to output direcotry, if toSave is true.}

\item{make_names}{Identify names of cell-type markers using the Fisher's exact test method (T/F).}

\item{internal}{If this function is pre-processing from Panglao (T/F).}
}
\value{
List with the following elements:
\item{pVal}{A dataframe containing the signature matrix of ranks (-log10(Padj) * sign(fold-change)).}
\item{OR}{A dataframe containing the signature matrix of odds ratios.}
\item{cellname}{A vector of the cell-labels returned from the GSVA method.}
\item{topGenes}{the top 30 mos expressed genes in each cell-type.}
}
\description{
Convert a list of cell-type markers from FindMarkers in Seurat to a signature matrix defined by odds ratio and rank.
}
\details{
Take a list of compiled differentially expressed genes from different cell-types, identify what the cell-types are using the Fisher's exact test, and then convert into a signature matrix for both the adjusted p-value and odds ratio.
}
\examples{

data(POA_example)
 POA_generes <- POA_example$POA_generes
signature <- generes_to_heatmap(POA_generes,species = -9, make_names = FALSE)



}
