% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scPOEM.R
\name{scPOEM}
\alias{scPOEM}
\title{Main Function.}
\usage{
scPOEM(
  mode = c("single", "compare"),
  input_data,
  dirpath = tempdir(),
  count_device = 1,
  nComp = 5,
  seed = NULL,
  numwalks = 5,
  walklength = 3,
  epochs = 100,
  neg_sample = 5,
  batch_size = 32,
  weighted = TRUE,
  exclude_pos = FALSE,
  d = 100,
  rebuild_GGN = TRUE,
  rebuild_PPN = TRUE,
  rebuild_PGN_Lasso = TRUE,
  rebuild_PGN_RF = TRUE,
  rebuild_PGN_XGB = TRUE,
  relearn_pg_embedding = TRUE,
  save_file = TRUE,
  pg_method = c("Lasso", "RF", "XGBoost"),
  python_env = "scPOEM_env"
)
}
\arguments{
\item{mode}{The mode indicating whether to analyze data from a single condition or to compare two conditions.}

\item{input_data}{A list of input data.

If \code{mode = "single"}, \code{input_data} must be a list containing the following \strong{seven objects}:
\itemize{
\item \code{X}: The scATAC-seq data, sparse matrix.
\item \code{Y}: The scRNA-seq data, sparse matrix.
\item \code{peak_data}: A data.frame containing peak information.
\item \code{gene_data}: A data.frame containing gene information (must contain a column "gene_name").
\item \code{cell_data}: A data.frame containing cell metadata.
\item \code{neibor_peak}: The peak IDs within a certain range of each gene, must have cols c("gene_name", "start_use", "end_use"). The id numbers in "start_use" and "end_use" are start from 0.
\item \code{genome}: The genome length for the species.
}

If \code{mode = "compare"}, \code{input_data} must be a \strong{named list of two elements}, with names corresponding to two state names (e.g., "S1" and "S2"). Each element must itself be a list containing the same seven components as described above for \code{mode = "single"}.}

\item{dirpath}{The folder path to read or write file.}

\item{count_device}{The number of cpus used to train models.}

\item{nComp}{The number of PCs used for regression in constructing GGN.}

\item{seed}{An integer specifying the random seed to ensure reproducible results.}

\item{numwalks}{Number of random walks per node. Default is 5.}

\item{walklength}{Length of walk depth. Default is 3.}

\item{epochs}{Number of training epochs. Default is 100.}

\item{neg_sample}{Number of negative samples per positive sample. Default is 5.}

\item{batch_size}{Batch size for training. Default is 32.}

\item{weighted}{Whether the sampling network is weighted. Default is TRUE.}

\item{exclude_pos}{Whether to exclude positive samples from negative sampling. Default is FALSE.}

\item{d}{The dimension of latent space. Default is 100.}

\item{rebuild_GGN}{Logical. Whether to rebuild the gene-gene network from scratch. If FALSE, the function will attempt to read from \code{GGN.mtx} under \code{dirpath/test} in \code{single} mode or \code{dirpath/state_name/test} in compare mode.}

\item{rebuild_PPN}{Logical. Whether to rebuild the peak-peak network from scratch. If FALSE, the function will attempt to read from \code{PPN.mtx} under \code{dirpath/test} in \code{single} mode or \code{dirpath/state_name/test} in compare mode.}

\item{rebuild_PGN_Lasso}{Logical. Whether to rebuild the peak-gene network via Lasso from scratch. If FALSE, the function will attempt to read from \code{PGN_Lasso.mtx} under \cr \code{dirpath/test} in single mode or \code{dirpath/state_name/test} in compare mode.}

\item{rebuild_PGN_RF}{Logical. Whether to rebuild the peak-gene network via random forest from scratch. If FALSE, the function will attempt to read from \code{PGN_RF.mtx} under \code{dirpath/test} in single mode or \code{dirpath/state_name/test} in compare mode.}

\item{rebuild_PGN_XGB}{Logical. Whether to rebuild the peak-gene network via XGBoost from scratch. If FALSE, the function will attempt to read from \code{PGN_XGB.mtx} under \cr \code{dirpath/test} in single mode or \code{dirpath/state_name/test} in compare mode.}

\item{relearn_pg_embedding}{Logical. Whether to relearn the low-dimensional representations for peaks and genes from scratch. If FALSE, the function will attempt to read from \cr\code{node_embeddings.mtx}, \code{node_used_peak.csv}, \code{node_used_gene.csv} \cr under \code{dirpath/embedding} in single mode or \cr \code{dirpath/state_name/embedding} in compare mode.}

\item{save_file}{Logical, whether to save the output to a file.}

\item{pg_method}{The vector of methods used to construct peak-gene net. Default is c("Lasso", "RF", "XGBoost").}

\item{python_env}{Name or path of the Python environment to be used.}
}
\value{
The scPOEM result. \describe{
\item{Single Mode}{Returns a list containing the following elements:
\describe{
\item{\code{E}}{Low-dimensional representations of peaks and genes.}
\item{\code{peak_node}}{Peak IDs that are associated with other peaks or genes.}
\item{\code{gene_node}}{Gene IDs that are associated with other peaks or genes.}
}
}
\item{Compare Mode}{Returns a list containing the following elements:
\describe{
\item{\code{state1 name}}{The single-mode result for the first condition.}
\item{\code{state2 name}}{The single-mode result for the second condition.}
\item{\code{compare}}{A summary list containing:
\describe{
\item{\code{E_g2}}{Low-dimensional embedding representations of genes under the two conditions.}
\item{\code{common_genes}}{Genes shared between both conditions and used in the analysis.}
\item{\code{diffRegulation}}{A list of differential regulatory information for each gene.}
}
}
}
}
}
}
\description{
This function takes paired single-cell ATAC-seq (scATAC-seq) and RNA-seq (scRNA-seq) data to embed peaks and genes into a shared low-dimensional space. It integrates regulatory relationships from peak-peak interactions (via Cicero), peak-gene interactions (via Lasso, random forest, and XGBoost), and gene-gene interactions (via principal component regression). Additionally, it supports gene-gene network reconstruction using epsilon-NN projections and compares networks across conditions through manifold alignment (scTenifoldNet).
}
\examples{
\donttest{
library(scPOEM)
library(monocle)
dirpath <- "./example_data"
# An example for analysing a single dataset.
# Download and read data.
data(example_data_single)
single_result <- scPOEM(mode = "single",
                        input_data=example_data_single,
                        dirpath=file.path(dirpath, "single"),
                        save_file=FALSE)

# An example for analysing and comparing datasets from two conditions.
# Download compare mode example data
data(example_data_compare)
compare_result <- scPOEM(mode = "compare",
                         input_data=example_data_compare,
                         dirpath=file.path(dirpath, "compare"),
                         save_file=FALSE)

}
}
