% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-continuous.R
\name{cscale}
\alias{cscale}
\title{Continuous scale}
\usage{
cscale(x, palette, na.value = NA_real_, trans = transform_identity())
}
\arguments{
\item{x}{vector of continuous values to scale}

\item{palette}{palette to use.

Built in palettes:
\Sexpr[results=rd,stage=build]{scales:::seealso_pal()}}

\item{na.value}{value to use for missing values}

\item{trans}{transformation object describing the how to transform the
raw data prior to scaling.  Defaults to the identity transformation which
leaves the data unchanged.

Built in transformations:
\Sexpr[results=rd,stage=build]{scales:::seealso_transform()}.}
}
\description{
Continuous scale
}
\examples{
with(mtcars, plot(disp, mpg, cex = cscale(hp, pal_rescale())))
with(mtcars, plot(disp, mpg, cex = cscale(hp, pal_rescale(),
  trans = transform_sqrt()
)))
with(mtcars, plot(disp, mpg, cex = cscale(hp, pal_area())))
with(mtcars, plot(disp, mpg,
  pch = 20, cex = 5,
  col = cscale(hp, pal_seq_gradient("grey80", "black"))
))
}
