% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_graphics.R
\name{plotResultsAllLambda}
\alias{plotResultsAllLambda}
\title{Plot both the spatial and temporal components for the sequence of lambda values from Step 3 of SCALPEL.}
\usage{
plotResultsAllLambda(
  scalpelOutput,
  neuronsToDisplay = NULL,
  colVec = NULL,
  titleA = "",
  ylabZ = "",
  fileName = NULL,
  pctTransp = 0.7,
  number = TRUE,
  border = FALSE
)
}
\arguments{
\item{scalpelOutput}{An object returned by one of the SCALPEL functions:
\code{\link{scalpel}} or \code{\link{scalpelStep3}}.}

\item{neuronsToDisplay}{Vector giving which neurons' spatial and temporal components to plot. The indices refer to which columns
of \code{scalpelOutput$Afilter} to plot. By default, all components are plotted. Users may also specify \code{"kept"},
which will exclude all dictionary elements discarded using a previous call to \code{\link{reviewNeurons}} or \code{\link{reviewNeuronsInteractive}}.}

\item{colVec}{Vector of colors to use, which are chosen automatically if the default value of NULL is used.}

\item{titleA}{Label for the title of the spatial components plot.}

\item{ylabZ}{Label for the y-axis of the temporal components plot.}

\item{fileName}{If provided, the plot will be saved to the specified location.}

\item{pctTransp}{The percent transparency (in [0,1]) for the colors used to plot the neurons. The default value is 0.7.}

\item{number}{Logical value indicating whether the neurons should be numbered.}

\item{border}{Logical value indicating whether only the borders of the neurons should be plotted.}
}
\value{
None
}
\description{
We plot the temporal components, displaying the estimated fluorescence over time for each spatial component, along with a map of the spatial components for a whole sequence of lambda values.
}
\details{
Temporal components that were zeroed out in the sparse group lasso and their corresponding spatial components
are shown in gray for both plots.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function

#simplest example with default parameters:
plotResultsAllLambda(scalpelOutput = scalpelOutput)

#example with optional parameters:
#plot only two of the neurons, do not number neurons, draw the outlines of the neurons
plotResultsAllLambda(scalpelOutput = scalpelOutput, neuronsToDisplay = c(1,2),
                    number = FALSE, border = TRUE)
}
}
\seealso{
\code{\link{scalpelStep3}}, \code{\link{scalpel}}, \code{\link{plotSpatial}}, \code{\link{plotTemporal}}
}
