.male.names <- c("Jacob", "Mason", "Ethan", "Noah", "William", "Liam", "Jayden", "Michael", "Alexander", "Aiden", "Daniel", "Matthew", "Elijah", "James", "Anthony", "Benjamin", "Joshua", "Andrew", "David", "Joseph", "Logan", "Jackson", "Christopher", "Gabriel", "Samuel", "Ryan", "Lucas", "John", "Nathan", "Isaac", "Dylan", "Caleb", "Christian", "Landon", "Jonathan", "Carter", "Luke", "Owen", "Brayden", "Gavin", "Wyatt", "Isaiah", "Henry", "Eli", "Hunter", "Jack", "Evan", "Jordan", "Nicholas", "Tyler", "Aaron", "Jeremiah", "Julian", "Cameron", "Levi", "Brandon", "Angel", "Austin", "Connor", "Adrian", "Robert", "Charles", "Thomas", "Sebastian", "Colton", "Jaxon", "Kevin", "Zachary", "Ayden", "Dominic", "Blake", "Jose", "Oliver", "Justin", "Bentley", "Jason", "Chase", "Ian", "Josiah", "Parker", "Xavier", "Adam", "Cooper", "Nathaniel", "Grayson", "Jace", "Carson", "Nolan", "Tristan", "Luis", "Brody", "Juan", "Hudson", "Bryson", "Carlos", "Easton", "Damian", "Alex", "Kayden", "Ryder", "Jesus", "Cole", "Micah", "Vincent", "Max", "Jaxson", "Eric", "Asher", "Hayden", "Diego", "Miles", "Steven", "Ivan", "Elias", "Aidan", "Maxwell", "Bryce", "Antonio", "Giovanni", "Timothy", "Bryan", "Santiago", "Colin", "Richard", "Braxton", "Kaleb", "Kyle", "Kaden", "Preston", "Miguel", "Jonah", "Lincoln", "Riley", "Leo", "Victor", "Brady", "Jeremy", "Mateo", "Brian", "Jaden", "Ashton", "Patrick", "Declan", "Sean", "Joel", "Gael", "Sawyer", "Alejandro", "Marcus", "Leonardo", "Jesse", "Caden", "Jake", "Kaiden", "Wesley", "Camden", "Edward", "Brantley", "Roman", "Axel", "Silas", "Jude", "Grant", "Cayden", "Emmanuel", "George", "Maddox", "Malachi", "Bradley", "Alan", "Weston", "Gage", "Devin", "Greyson", "Kenneth", "Mark", "Oscar", "Tanner", "Rylan", "Nicolas", "Harrison", "Derek", "Peyton", "Ezra", "Tucker", "Emmett", "Avery", "Cody", "Calvin", "Andres", "Jorge", "Abel", "Paul", "Abraham", "Kai", "Collin", "Theodore", "Ezekiel", "Omar", "Jayce", "Conner", "Bennett", "Trevor", "Eduardo", "Peter", "Maximus", "Jaiden", "Jameson", "Seth", "Kingston", "Javier", "Travis", "Garrett", "Everett", "Graham", "Xander", "Cristian", "Damien", "Ryker", "Griffin", "Corbin", "Myles", "Luca", "Zane", "Francisco", "Ricardo", "Alexis", "Stephen", "Zayden", "Iker", "Drake", "Lukas", "Charlie", "Spencer", "Zion", "Erick", "Josue", "Jeffrey", "Trenton", "Chance", "Paxton", "Elliot", "Fernando", "Keegan", "Landen", "Manuel", "Amir", "Shane", "Raymond", "Zander", "Andre", "Israel", "Mario", "Cesar", "Simon", "King", "Jaylen", "Johnathan", "Troy", "Dean", "Clayton", "Dominick", "Tyson", "Jasper", "Martin", "Kyler", "Hector", "Edgar", "Marco", "Cash", "Edwin", "Shawn", "Judah", "Andy", "Donovan", "Kameron", "Elliott", "Dante", "Braylon", "Anderson", "Johnny", "Drew", "Sergio", "Cruz", "Dalton", "Rafael", "Gregory", "Lane", "Erik", "Skyler", "Finn", "Reid", "Gunner", "Jared", "Caiden", "Holden", "Emilio", "Fabian", "Aden", "Brendan", "Rowan", "Emiliano", "Braden", "Jase", "Jax", "Emanuel", "Lorenzo", "Roberto", "Amari", "Angelo", "Beau", "Louis", "Derrick", "Beckett", "Dawson", "Felix", "Pedro", "Brennan", "Frank", "Maximiliano", "Quinn", "Dallas", "Romeo", "Braylen", "Joaquin", "Waylon", "Allen", "Colt", "Ruben", "Milo", "Julius", "Grady", "August", "Dakota", "Cohen", "Brock", "Kellen", "Brycen", "Desmond", "Malik", "Colby", "Nehemiah", "Leland", "Jett", "Marcos", "Taylor", "Karter", "Marshall", "Ty", "Phillip", "Corey", "Ali", "Adan", "Dillon", "Arthur", "Maverick", "Leon", "Brooks", "Tristen", "Titus", "Keith", "Dexter", "Karson", "Emerson", "Landyn", "Armando", "Pablo", "Knox", "Enrique", "Cade", "Gerardo", "Reed", "Kellan", "Jayson", "Barrett", "Walter", "Dustin", "Kolton", "Ronald", "Trent", "Phoenix", "Ismael", "Julio", "Danny", "Kason", "Scott", "Messiah", "Jay", "Esteban", "Gideon", "Tate", "Abram", "Trey", "Keaton", "Jakob", "Jaime", "Devon", "Braydon", "Izaiah", "Donald", "Albert", "Raul", "Darius", "Archer", "Colten", "Damon", "River", "Gustavo", "Philip", "Atticus", "Walker", "Matteo", "Randy", "Saul", "Rocco", "Davis", "Enzo", "Noel", "Orion", "Jamari", "Remington", "Bruce", "Darren", "Larry", "Mathew", "Russell", "Dennis", "Tony", "Chris", "Porter", "Rodrigo", "Armani", "Zaiden", "Kade", "Ari", "Hugo", "Zachariah", "Kamden", "Mohamed", "Quentin", "Solomon", "Curtis", "Leonel", "Issac", "Khalil", "Alberto", "Jerry", "Alec", "Gianni", "Moises", "Gunnar", "Adriel", "Lawrence", "Alijah", "Chandler", "Ronan", "Prince", "Payton", "Arturo", "Jimmy", "Orlando", "Ricky", "Mitchell", "Maximilian", "Cason", "Malcolm", "Muhammad", "Kasen", "Marvin", "Jalen", "Cyrus", "Mauricio", "Warren", "Jonas", "Kendrick", "Rhys", "Dane", "Ryland", "Pierce", "Johan", "Rory", "Uriel", "Major", "Bryant", "Reece", "Casey", "Ibrahim", "Nikolas", "Arjun", "Sullivan", "Finnegan", "Alfredo", "Royce", "Ahmed", "Amare", "Lance", "Ramon", "Jamison", "Brayan", "Brenden", "Dominik", "Case", "Kristopher", "Maurice", "Mekhi", "Kobe", "Zackary", "Rhett", "Jensen", "Jaxton", "Deandre", "Isaias", "Channing", "Yahir", "Ezequiel", "Tobias", "Talon", "Sam", "Justice", "Kash", "Nash", "Alvin", "Jacoby", "Ace", "Nico", "Quinton", "Cannon", "Franklin", "Raiden", "Joe", "Lawson", "Beckham", "Gary", "Aldo", "Raylan", "Frederick", "London", "Boston", "Carl", "Byron", "Ernesto", "Moshe", "Terry", "Eddie", "Kane", "Moses", "Finley", "Salvador", "Reese", "Kelvin", "Cullen", "Madden", "Wade", "Clark", "Mohammed", "Kieran", "Jagger", "Dorian", "Korbin", "Nelson", "Roy", "Asa", "Matias", "Nasir", "Nickolas", "Roger", "Alonzo", "Jaxen", "Skylar", "Callen", "Malakai", "Douglas", "Ahmad", "Uriah", "Conor", "Kristian", "Carmelo", "Blaine", "Kayson", "Bentlee", "Braeden", "Julien", "Nathanael", "Aarav", "Keagan", "Lucian", "Morgan", "Chad", "Terrance", "Benson", "Noe", "Rodney", "Francis", "Layne", "Mohammad", "Zayne", "Tatum", "Brett", "Wilson", "Kian", "Marc", "Rohan", "Dayton", "Braiden", "Harper", "Luciano", "Nikolai", "Kamari", "Camron", "Joey", "Santino", "Ellis", "Layton", "Xzavier", "Jefferson", "Winston", "Guillermo", "Demetrius", "Bowen", "Daxton", "Melvin", "Soren", "Neil", "Sylas", "Jon", "Raphael", "Rex", "Yusuf", "Shaun", "Brodie", "Tommy", "Harley", "Quincy", "Dax", "Trace", "Adonis", "Bently", "Giovani", "Jeffery", "Odin", "Luka", "Kylan", "Willie", "Lewis", "Tripp", "Vihaan", "Davion", "Kendall", "Arian", "Cory", "Jamarion", "Jonathon", "Nixon", "Rayan", "Emery", "Jermaine", "Reginald", "Tomas", "Emmitt", "Ayaan", "Zechariah", "Billy", "Hamza", "Micheal", "Urijah", "Aryan", "Lee", "Jasiah", "Landry", "Crosby", "Mathias", "Toby", "Tristian", "Will", "Felipe", "Triston", "Eden", "Terrell", "Deacon", "Matthias", "Jamal", "Makai", "Maxim", "Sterling", "Hank", "Gerald", "Alessandro", "Jaydon", "Hayes", "Niko", "Branson", "Flynn", "Kody", "Marlon", "Mayson", "Allan", "Augustus", "Jessie", "Neymar", "Adrien", "Aydan", "Leonard", "Sincere", "Kyson", "Terrence", "Jerome", "Jadiel", "Kole", "Aron", "Aydin", "Omari", "Ronnie", "Zain", "Vicente", "Bobby", "Yosef", "Alexzander", "Harry", "Kale", "Rogelio", "Casen", "Ray", "Clay", "Masen", "Sage", "Ulises", "Kymani", "Chaim", "Javon", "Brent", "Jadon", "Elisha", "Stanley", "Jovanni", "Princeton", "Alonso", "Darian", "Conrad", "Dwayne", "Eugene", "Gauge", "Rene", "Kareem", "Roland", "Ben", "Vincenzo", "Abdullah", "Camren", "Kenny", "Brentley", "Memphis", "Blaze", "Edison", "Osvaldo", "Teagan", "Westin", "Deshawn", "Rayden", "Cedric", "Marquis", "Samir", "Steve", "Draven", "Jairo", "Giovanny", "Brennen", "Bronson", "Crew", "Davin", "Kolten", "Ronin", "Ariel", "Semaj", "Alden", "Isiah", "Lennox", "Davian", "Jaylin", "Cain", "Wayne", "Craig", "Lamar", "Leonidas", "Cristopher", "Otto", "Bo", "Darrell", "Kolby", "Marcelo", "Bruno", "Fletcher", "Justus", "Alfonso", "Theo", "Tyrone", "Aidyn", "Harvey", "Rudy", "Brendon", "Tristin", "Dominique", "Kaeden", "Samson", "Kyree", "Jovani", "Lionel", "Amos", "Giancarlo", "Misael", "Callum", "Quintin", "Valentino", "Gavyn", "Lennon", "Jamir", "Kamron", "Zavier", "Arlo", "Junior", "Killian", "Leandro", "Konnor", "Hezekiah", "Jordyn", "Markus", "Ramiro", "Callan", "Chace", "Johnathon", "Lyric", "Fisher", "Rashad", "Kamryn", "Legend", "Duncan", "Harold", "Camilo", "Hendrix", "Seamus", "Coleman", "Vance", "Rylee", "Elian", "Jaeden", "Jamie", "Krish", "Abdiel", "Antoine", "Camdyn", "Van", "Branden", "Cayson", "Gibson", "Javion", "Izayah", "Darwin", "Jamar", "Mike", "Randall", "Brecken", "Hassan", "Thiago", "Heath", "Arnav", "Kingsley", "Kyrie", "Xavi", "Damari", "Deangelo", "Jionni", "Joziah", "Makhi", "Vaughn", "Zeke", "Konner", "Ean", "Frankie", "Yael", "Benton", "Oakley", "Efrain", "Marcel", "Rolando", "Maxton", "Jaycob", "Keenan", "Rowen", "Yousef", "Ishaan", "Jedidiah", "Remy", "Todd", "Reagan", "Bodhi", "Damarion", "Juelz", "Valentin", "Austyn", "Broderick", "Anders", "Alvaro", "Mustafa", "Thaddeus", "Brenton", "Cale", "Clinton", "Derick", "Jorden", "Gilberto", "Jabari", "Rey", "Salvatore", "Freddy", "Donte", "Ernest", "Aaden", "Axton", "Blaise", "Lucca", "Maximo", "Sidney", "Dario", "Rodolfo", "Trevon", "Camryn", "Deegan", "Sonny", "Cassius", "Truman", "Brice", "Brogan", "Hugh", "Yehuda", "Agustin", "Eliot", "Stefan", "Zaid", "Bridger", "Damion", "Eliseo", "Houston", "Johann", "Leroy", "Sheldon", "Dariel", "Darryl", "Isai", "Tyrell", "Alfred", "Demarcus", "Kohen", "Ignacio", "Rylen", "Santos", "Cael", "Davon", "Kaysen", "Mack", "Darien", "Ross", "Titan", "Tyree", "Ameer", "Zaire", "Aditya", "Briggs", "Immanuel", "Malaki", "Turner", "Bradyn", "Graysen", "Kase", "Reuben", "Yandel", "Gaige", "Jaidyn", "Franco", "Trystan", "Maison", "Simeon", "Anton", "Darnell", "Emory", "Roderick", "Deon", "Devan", "Graeme", "Howard", "Jael", "Kael", "Karsen", "Jarrett", "Apollo", "Denzel", "Foster", "Gilbert", "Jaylon", "Kylen", "Augustine")	
.female.names <- c("Sophia", "Emma", "Isabella", "Olivia", "Ava", "Emily", "Abigail", "Mia", "Madison", "Elizabeth", "Chloe", "Ella", "Avery", "Addison", "Aubrey", "Lily", "Natalie", "Sofia", "Charlotte", "Zoey", "Grace", "Hannah", "Amelia", "Harper", "Lillian", "Samantha", "Evelyn", "Victoria", "Brooklyn", "Zoe", "Layla", "Hailey", "Leah", "Kaylee", "Anna", "Aaliyah", "Gabriella", "Allison", "Nevaeh", "Alexis", "Audrey", "Savannah", "Sarah", "Alyssa", "Claire", "Taylor", "Riley", "Camila", "Arianna", "Ashley", "Brianna", "Sophie", "Peyton", "Bella", "Khloe", "Genesis", "Alexa", "Serenity", "Kylie", "Aubree", "Scarlett", "Stella", "Maya", "Katherine", "Julia", "Lucy", "Madelyn", "Autumn", "Makayla", "Kayla", "Mackenzie", "Lauren", "Gianna", "Ariana", "Faith", "Alexandra", "Melanie", "Sydney", "Bailey", "Caroline", "Naomi", "Morgan", "Kennedy", "Ellie", "Jasmine", "Eva", "Skylar", "Kimberly", "Violet", "Molly", "Aria", "Jocelyn", "Trinity", "London", "Lydia", "Madeline", "Reagan", "Piper", "Andrea", "Annabelle", "Maria", "Brooke", "Payton", "Paisley", "Paige", "Ruby", "Nora", "Mariah", "Rylee", "Lilly", "Brielle", "Jade", "Destiny", "Nicole", "Mila", "Kendall", "Liliana", "Kaitlyn", "Natalia", "Sadie", "Jordyn", "Vanessa", "Mary", "Mya", "Penelope", "Isabelle", "Alice", "Reese", "Gabrielle", "Hadley", "Katelyn", "Angelina", "Rachel", "Isabel", "Eleanor", "Clara", "Brooklynn", "Jessica", "Elena", "Aliyah", "Vivian", "Laila", "Sara", "Amy", "Eliana", "Lyla", "Juliana", "Valeria", "Adriana", "Makenzie", "Elise", "Mckenzie", "Quinn", "Delilah", "Cora", "Kylee", "Rebecca", "Gracie", "Izabella", "Josephine", "Alaina", "Michelle", "Jennifer", "Eden", "Valentina", "Aurora", "Catherine", "Stephanie", "Valerie", "Jayla", "Willow", "Daisy", "Alana", "Melody", "Hazel", "Summer", "Melissa", "Margaret", "Kinsley", "Kinley", "Ariel", "Lila", "Giselle", "Ryleigh", "Haley", "Julianna", "Ivy", "Alivia", "Brynn", "Keira", "Daniela", "Aniyah", "Angela", "Kate", "Londyn", "Hayden", "Harmony", "Adalyn", "Megan", "Allie", "Gabriela", "Alayna", "Presley", "Jenna", "Alexandria", "Ashlyn", "Adrianna", "Jada", "Fiona", "Norah", "Emery", "Maci", "Miranda", "Ximena", "Amaya", "Cecilia", "Ana", "Shelby", "Katie", "Hope", "Callie", "Jordan", "Luna", "Leilani", "Eliza", "Mckenna", "Angel", "Genevieve", "Makenna", "Isla", "Lola", "Danielle", "Chelsea", "Leila", "Tessa", "Adelyn", "Camille", "Mikayla", "Adeline", "Adalynn", "Sienna", "Esther", "Jacqueline", "Emerson", "Arabella", "Maggie", "Athena", "Lucia", "Lexi", "Ayla", "Diana", "Alexia", "Juliet", "Josie", "Allyson", "Addyson", "Delaney", "Teagan", "Marley", "Amber", "Rose", "Erin", "Leslie", "Kayleigh", "Amanda", "Kathryn", "Kelsey", "Emilia", "Alina", "Kenzie", "Kaydence", "Alicia", "Alison", "Paris", "Sabrina", "Ashlynn", "Lilliana", "Sierra", "Cassidy", "Laura", "Alondra", "Iris", "Kyla", "Christina", "Carly", "Jillian", "Madilyn", "Kyleigh", "Madeleine", "Cadence", "Nina", "Evangeline", "Nadia", "Raegan", "Lyric", "Giuliana", "Briana", "Georgia", "Yaretzi", "Elliana", "Haylee", "Fatima", "Phoebe", "Selena", "Charlie", "Dakota", "Annabella", "Abby", "Daniella", "Juliette", "Lilah", "Bianca", "Mariana", "Miriam", "Parker", "Veronica", "Gemma", "Noelle", "Cheyenne", "Marissa", "Heaven", "Vivienne", "Brynlee", "Joanna", "Mallory", "Aubrie", "Journey", "Nyla", "Cali", "Tatum", "Carmen", "Gia", "Jazmine", "Heidi", "Miley", "Baylee", "Elaina", "Macy", "Ainsley", "Jane", "Raelynn", "Anastasia", "Adelaide", "Ruth", "Camryn", "Kiara", "Alessandra", "Hanna", "Finley", "Maddison", "Lia", "Bethany", "Karen", "Kelly", "Malia", "Jazmin", "Jayda", "Esmeralda", "Kira", "Lena", "Kamryn", "Kamila", "Karina", "Eloise", "Kara", "Elisa", "Rylie", "Olive", "Nayeli", "Tiffany", "Macie", "Skyler", "Addisyn", "Angelica", "Briella", "Fernanda", "Annie", "Maliyah", "Amiyah", "Jayden", "Charlee", "Caitlyn", "Elle", "Crystal", "Julie", "Imani", "Kendra", "Talia", "Angelique", "Jazlyn", "Guadalupe", "Alejandra", "Emely", "Lucille", "Anya", "April", "Elsie", "Madelynn", "Myla", "Julissa", "Scarlet", "Helen", "Breanna", "Kyra", "Madisyn", "Rosalie", "Brittany", "Brylee", "Jayleen", "Arielle", "Karla", "Kailey", "Arya", "Sarai", "Harley", "Miracle", "Kaelyn", "Kali", "Cynthia", "Daphne", "Aleah", "Caitlin", "Cassandra", "Holly", "Janelle", "Marilyn", "Katelynn", "Kaylie", "Itzel", "Carolina", "Bristol", "Haven", "Michaela", "Monica", "June", "Janiyah", "Camilla", "Jamie", "Rebekah", "Audrina", "Dayana", "Lana", "Serena", "Tiana", "Nylah", "Braelyn", "Savanna", "Skye", "Raelyn", "Madalyn", "Sasha", "Perla", "Bridget", "Aniya", "Rowan", "Logan", "Mckinley", "Averie", "Jaylah", "Aylin", "Joselyn", "Nia", "Hayley", "Lilian", "Adelynn", "Jaliyah", "Kassidy", "Kaylin", "Kadence", "Celeste", "Jaelyn", "Zariah", "Tatiana", "Jimena", "Lilyana", "Anaya", "Catalina", "Viviana", "Cataleya", "Sloane", "Courtney", "Johanna", "Amari", "Melany", "Anabelle", "Francesca", "Ada", "Alanna", "Priscilla", "Danna", "Angie", "Kailyn", "Lacey", "Sage", "Lillie", "Brinley", "Caylee", "Joy", "Kenley", "Vera", "Bailee", "Amira", "Aileen", "Aspen", "Emmalyn", "Erica", "Gracelyn", "Kennedi", "Skyla", "Annalise", "Danica", "Dylan", "Kiley", "Gwendolyn", "Jasmin", "Lauryn", "Aleena", "Justice", "Annabel", "Tenley", "Dahlia", "Gloria", "Lexie", "Lindsey", "Hallie", "Sylvia", "Elyse", "Annika", "Maeve", "Marlee", "Aryanna", "Kenya", "Lorelei", "Selah", "Kaliyah", "Adele", "Natasha", "Brenda", "Erika", "Alyson", "Braylee", "Emilee", "Raven", "Ariella", "Blakely", "Liana", "Jaycee", "Sawyer", "Anahi", "Jaelynn", "Elsa", "Farrah", "Cameron", "Evelynn", "Luciana", "Zara", "Madilynn", "Eve", "Kaia", "Helena", "Anne", "Estrella", "Leighton", "Nataly", "Whitney", "Lainey", "Amara", "Anabella", "Malaysia", "Samara", "Zoie", "Amani", "Phoenix", "Dulce", "Paola", "Marie", "Aisha", "Harlow", "Virginia", "Ember", "Regina", "Jaylee", "Anika", "Ally", "Kayden", "Alani", "Miah", "Yareli", "Journee", "Kiera", "Nathalie", "Mikaela", "Jaylynn", "Litzy", "Charley", "Claudia", "Aliya", "Madyson", "Cecelia", "Liberty", "Braelynn", "Evie", "Rosemary", "Myah", "Lizbeth", "Giana", "Ryan", "Teresa", "Ciara", "Isis", "Lea", "Shayla", "Jazlynn", "Rosa", "Gracelynn", "Desiree", "Elisabeth", "Isabela", "Arely", "Mariam", "Abbigail", "Emersyn", "Brenna", "Kaylynn", "Nova", "Raquel", "Dana", "Laney", "Laylah", "Siena", "Amelie", "Clarissa", "Lilianna", "Lylah", "Halle", "Madalynn", "Maleah", "Sherlyn", "Linda", "Shiloh", "Jessie", "Kenia", "Greta", "Marina", "Melina", "Amiya", "Bria", "Natalee", "Sariah", "Mollie", "Nancy", "Christine", "Felicity", "Zuri", "Irene", "Simone", "Amya", "Matilda", "Colette", "Kristen", "Paityn", "Alayah", "Janiya", "Kallie", "Mira", "Hailee", "Kathleen", "Meredith", "Janessa", "Noemi", "Aiyana", "Aliana", "Leia", "Mariyah", "Tori", "Alissa", "Ivanna", "Joslyn", "Sandra", "Maryam", "Saniyah", "Kassandra", "Danika", "Denise", "Jemma", "River", "Charleigh", "Emelia", "Kristina", "Armani", "Beatrice", "Jaylene", "Karlee", "Blake", "Cara", "Addilyn", "Amina", "Ansley", "Kaitlynn", "Iliana", "Mckayla", "Adelina", "Briley", "Elaine", "Lailah", "Mercedes", "Chaya", "Lindsay", "Hattie", "Lisa", "Marisol", "Patricia", "Bryanna", "Taliyah", "Adrienne", "Emmy", "Millie", "Paislee", "Charli", "Kourtney", "Leyla", "Maia", "Willa", "Milan", "Paula", "Ayleen", "Clare", "Kensley", "Reyna", "Martha", "Adley", "Elianna", "Emilie", "Karsyn", "Yasmin", "Lorelai", "Amirah", "Aryana", "Livia", "Alena", "Kiana", "Celia", "Kailee", "Rylan", "Ellen", "Galilea", "Kynlee", "Leanna", "Renata", "Mae", "Ayanna", "Chanel", "Lesly", "Cindy", "Carla", "Pearl", "Jaylin", "Kimora", "Angeline", "Carlee", "Aubri", "Edith", "Alia", "Frances", "Corinne", "Jocelynn", "Cherish", "Wendy", "Carolyn", "Lina", "Tabitha", "Winter", "Abril", "Bryn", "Jolie", "Yaritza", "Casey", "Zion", "Lillianna", "Jordynn", "Zariyah", "Audriana", "Jayde", "Jaida", "Salma", "Diamond", "Malaya", "Kimber", "Ryann", "Abbie", "Paloma", "Destinee", "Kaleigh", "Asia", "Demi", "Yamileth", "Deborah", "Elin", "Kaiya", "Mara", "Averi", "Nola", "Tara", "Taryn", "Emmalee", "Aubrianna", "Janae", "Kyndall", "Jewel", "Zaniyah", "Kaya", "Sonia", "Alaya", "Heather", "Nathaly", "Shannon", "Ariah", "Avah", "Giada", "Lilith", "Samiyah", "Sharon", "Coraline", "Eileen", "Julianne", "Milania", "Chana", "Regan", "Krystal", "Rihanna", "Sidney", "Hadassah", "Macey", "Mina", "Paulina", "Rayne", "Kaitlin", "Maritza", "Susan", "Raina", "Hana", "Keyla", "Temperance", "Aimee", "Alisson", "Charlize", "Kendal", "Lara", "Roselyn", "Alannah", "Alma", "Dixie", "Larissa", "Patience", "Taraji", "Sky", "Zaria", "Aleigha", "Alyvia", "Aviana", "Bryleigh", "Elliot", "Jenny", "Luz", "Ali", "Alisha", "Ayana", "Campbell", "Karis", "Lilyanna", "Azaria", "Blair", "Micah", "Moriah", "Myra", "Lilia", "Aliza", "Giovanna", "Karissa", "Saniya", "Emory", "Estella", "Juniper", "Kairi", "Kenna", "Meghan", "Abrielle", "Elissa", "Rachael", "Emmaline", "Jolene", "Joyce", "Britney", "Carlie", "Haylie", "Judith", "Renee", "Saanvi", "Yesenia", "Barbara", "Dallas", "Jaqueline", "Karma", "America", "Sariyah", "Azalea", "Everly", "Ingrid", "Lillyana", "Emmalynn", "Marianna", "Brisa", "Kaelynn", "Leona", "Libby", "Deanna", "Mattie", "Miya", "Kai", "Annalee", "Nahla", "Dorothy", "Kaylyn", "Rayna", "Araceli", "Cambria", "Evalyn", "Haleigh", "Thalia", "Jakayla", "Maliah", "Saige", "Avianna", "Charity", "Kaylen", "Raylee", "Tamia", "Aubrielle", "Bayleigh", "Carley", "Kailynn", "Katrina", "Belen", "Karlie", "Natalya", "Alaysia", "Celine", "Milana", "Monroe", "Estelle", "Meadow", "Audrianna", "Cristina", "Harlee", "Jazzlyn", "Scarlette", "Zahra", "Akira", "Ann", "Collins", "Kendyl", "Anabel", "Azariah", "Carissa", "Milena", "Tia", "Alisa", "Bree", "Carleigh", "Cheyanne", "Sarahi", "Laurel", "Kylah", "Tinley", "Kora", "Marisa", "Esme", "Sloan", "Cailyn", "Gisselle", "Kasey", "Kyndal", "Marlene", "Riya", "Annabell", "Aubriana", "Izabelle", "Kirsten", "Aya", "Dalilah", "Devyn", "Geraldine", "Analia", "Hayleigh", "Landry", "Sofie", "Tess", "Ashtyn", "Jessa", "Katalina")	
.names <- c(.male.names, .female.names)
                                    
rSC <- function(n = 1, MT = 20, B.start = 6, m = 50, s = 10, prob = 0.5, d.trend = 0, d.level = 0.0, d.slope = 0.0, rtt = 0.80, concise = TRUE, cases = 1, round = NA, extreme.p = 0, extreme.d = c(-4,-3), missing.p = 0, distribution = "normal", start.values.fixed = FALSE, random.names = FALSE, output.long = FALSE) {
  
  MT <- rep(MT, length.out = n * cases)
  m <- rep(m, length.out = n * cases)
  s <- rep(s, length.out = n * cases)
  rtt <- rep(rtt, length.out = n * cases)
  extreme.p <- rep(extreme.p, length.out = n * cases)
  missing.p <- rep(missing.p, length.out = n * cases)
  d.level <- rep(d.level, length.out = n * cases)
  d.slope <- rep(d.slope, length.out = n * cases)
  d.trend <- rep(d.trend, length.out = n * cases)
  
  
  if (B.start[1] == "rand") {
    tmp.start <- round(as.numeric(B.start[2]) * MT)
    tmp.end <- round(as.numeric(B.start[3]) * MT)  
    B.start <- round(runif(n*cases, tmp.start, tmp.end))
  }
  
  if(any(B.start < 1) && any(B.start >= 1)) stop("A B.start vector must not include values below and above 1 at the same time.")
  if(B.start[1] < 1 && B.start[1] > 0) B.start <- round(B.start * MT)+1
  B.start <- rep(B.start, length.out = n * cases)  
  
  error <- sqrt(((1-rtt)/rtt) * s^2)
  
  dat <- list()
  for (i in 1:n) {
    if(cases > 1)
      dat[[i]] <- list()
    for (j in 1:cases) {
      B <- (i - 1) * cases + j
      if(distribution == "normal") {
        if(start.values.fixed)
          start_values <- rep(m[B], MT[B])
        else
          start_values <- rep(rnorm(1, m[B], s[B]), MT[B])	
        slope_values <- c(rep(0, B.start[B] - 1), 1:(MT[B] - B.start[B] + 1) * d.slope[B] * s[B])
        level_values <- c(rep(0, B.start[B] - 1), rep(d.level[B] * s[B], MT[B] - B.start[B] + 1))
        trend_values <- c(0 :(MT[B]-1) * d.trend[B] * s[B])
        true_values <- start_values + trend_values + slope_values + level_values
        error_values <- rnorm(MT[B], mean = 0, sd = error[B])
        measured_values <- true_values + error_values
      } else if(distribution == "poisson") {
        if(start.values.fixed)
          start_values <- rep(m[B], MT[B])	
        else
          start_values <- rep(rpois(1, m[B]), MT[B])	
        slope_values <- c(rep(0, B.start[B] - 1), 1:(MT[B] - B.start[B] + 1) * d.slope[B])
        level_values <- c(rep(0, B.start[B] - 1), rep(d.level[B], MT[B] - B.start[B] + 1))
        trend_values <- 0 :(MT[B]-1) * d.trend[B]
        true_values <- round(start_values + trend_values + slope_values + level_values)
        true_values[true_values < 0] <- 0
        measured_values <- rpois(length(true_values), true_values)
      } else if(distribution == "binomial") {
        if(start.values.fixed)
          start_values <- rep(m[B], MT[B])
        else
          start_values <- rep(rbinom(1, size = round(m[B] * (1/prob)), prob = prob), MT[B])	
        
        slope_values <- c(rep(0, B.start[B] - 1), 1:(MT[B] - B.start[B] + 1) * d.slope[B])
        level_values <- c(rep(0, B.start[B] - 1), rep(d.level[B], MT[B] - B.start[B] + 1))
        trend_values <- 0 :(MT[B]-1) * d.trend[B]
        true_values <- start_values + trend_values + slope_values + level_values
        true_values[true_values < 0] <- 0
        measured_values <- rbinom(n = length(true_values), size = round(true_values * (1/prob)), prob = prob)
      }
      if(extreme.p[B] > 0){
        ra <- runif(MT[B])
        if(distribution == "normal")
          multiplier <- s[B]
        if (distribution == "binomial" || distribution == "poisson")
          multiplier <- 1
        for(k in 1:MT[B]) {
          if(ra[k] <= extreme.p[B])
            measured_values[k] <- measured_values[k] + (runif(1, extreme.d[1], extreme.d[2]) * multiplier) 
        }
      }
      
      if(missing.p[B] > 0){
        measured_values[sample(1:MT[B], missing.p[B]*MT[B])] <- NA
      }
      
      if(!is.na(round))
        measured_values <- round(measured_values, round) 
      
      if (distribution == "binomial" || distribution == "poisson" || distribution == "poisson_old") 
        measured_values[measured_values < 0] <- 0
      
      condition <- c(rep("A", B.start[B] - 1), rep("B", MT[B] - B.start[B] + 1))
      if (cases == 1) {
        dat[[i]] <- data.frame(phase = condition, values = measured_values, mt = 1:MT[B])
        if (output.long){
          dat[[i]]$true <- true_values
          dat[[i]]$trend <- trend_values
          dat[[i]]$level <- level_values
          dat[[i]]$slope <- slope_values
          dat[[i]]$errors <- error_values
        }
        if(random.names)
          names(dat)[i] <- sample(.names,1)
      } else {
        dat[[i]][[j]] <- data.frame(phase = condition, values = measured_values, mt = 1:MT[B])
        if (output.long){
          dat[[i]][[j]]$true <- true_values
          dat[[i]][[j]]$trend <- trend_values
          dat[[i]][[j]]$level <- level_values
          dat[[i]][[j]]$slope <- slope_values
          dat[[i]][[j]]$errors <- error_values
        }
        if(random.names)
          names(dat[[i]])[j] <- sample(.names,1)
      }
    }
  }
  if(!concise) {
    cat("Create a random sample with the following parameters:\n\n")
    cat("Distribution:", distribution,"\n")
    cat("n\t",n,"\n")
    cat("Cases\t",cases,"\n")
    cat("M\t",unique(m),"\n")
    if(distribution == "normal")
      cat("SD\t",unique(s),"\n")
    if(distribution == "binomial")
      cat("Probab.\t",prob,"\n")
    cat("MT\t",unique(MT),"\n")
    cat("B.start\t",unique(B.start),"\n")
    if(distribution == "normal")
      cat("rtt\t",unique(rtt),"\n")
    cat("d level\t",unique(d.level),"\n")
    cat("d slope\t",unique(d.slope),"\n")
    cat("d trend\t",unique(d.trend),"\n")
    cat("p missing\t",unique(missing.p),"\n")
    
    if(any(extreme.p != 0)){
      cat("p extreme\t",unique(extreme.p),"\n")
      cat("d extreme low\t",extreme.d[1],"\n")
      cat("d extreme high\t",extreme.d[2],"\n")
      if (distribution == "binomial" || distribution == "poisson")
        cat("\n*effects sizes d represent frequencies (i.e., points for binomial distribution or counts for poisson distribution)\n")
      
    }
  }
  
  return(dat)
}
