% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatable_utility_functions.R
\name{create_table}
\alias{create_table}
\title{Create a \code{data.table} with all combinations of the supplied variables.}
\usage{
create_table(col_list, keys = NULL)
}
\arguments{
\item{col_list}{A named list of the variables you want in your 
\code{data.table}.}

\item{keys}{Character vector of one or more column names which is passed to 
\code{\link[data.table]{setkey}}.}
}
\value{
A \code{data.table} with all combinations of the variables supplied 
   in \code{col_list}.
}
\description{
Create a \code{data.table} with all combinations of the supplied variables.
}
\examples{
\dontrun{
cols <- list(location = 1:2, time = 0:2, stream = 1:2)
create_table(cols)
}
}
\keyword{internal}

