% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_zip.R
\name{zip_em_estimates}
\alias{zip_em_estimates}
\title{Estimates the ZIP relative risk and excess zero indicators for a window.}
\usage{
zip_em_estimates(p, mu, y, d_init = 0.5, tol = 0.01)
}
\arguments{
\item{p}{A numeric vector of the given/estimated excess zero probabilities 
corresponding to each count.}

\item{mu}{A numeric vector of the given/estimated Poisson expected value
parameters corresponding to each count. Of same length as \code{p}.}

\item{y}{An integer vector of the observed counts, of same length as 
\code{p}.}

\item{d_init}{A scalar between 0 and 1. The initial guess for the estimate of 
the excess zero indicator.}

\item{tol}{A scalar between 0 and 1. It is the absolute tolerance criterion
for the estimate of the excess zero indicator; convergence is reached when
two successive elements in the sequence of estimates have an absolute 
difference less than \code{tol}.}
}
\value{
A list with two elements:
\describe{
  \item{q}{Scalar estimate of the relative risk.}
  \item{dstar}{Estimates of the excess zero indicator variables.}
}
}
\description{
For a single spatial or space-time window, this function uses the EM 
algorithm to estimate the relative risk and the excess zero indicators for 
counts assumed to be generated from a zero-inflated Poisson distribution.
}
\keyword{internal}

