% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConNetGNN.R
\name{ConNetGNN}
\alias{ConNetGNN}
\title{Construct association networks for gene-gene, cell-cell, and gene-cell based on graph neural network (GNN)}
\usage{
ConNetGNN(
  Prep_data,
  python.path = NULL,
  miniconda.path = NULL,
  AE.epochs = 1000,
  AE.learning.rate = 0.001,
  AE.reg.alpha = 0.5,
  use.VGAE = TRUE,
  GAE.epochs = 300,
  GAE.learning.rate = 0.01,
  cell_val_ratio = 0.05,
  gene_val_ratio = 0.05,
  parallel = FALSE,
  seed = 125,
  verbose = TRUE
)
}
\arguments{
\item{Prep_data}{The input data is the result from the \code{Preprocessing} function.}

\item{python.path}{The path to a Python binary.}

\item{miniconda.path}{The path in which miniconda will be installed. If the \code{python.path} is NULL and conda or miniconda is not installed in the system, the program will automatically install miniconda according to the path specified by \code{miniconda.path}.}

\item{AE.epochs}{The number of epoch for the deep neural network (AE). Default: \code{1000}.}

\item{AE.learning.rate}{Initial learning rate of AE. Default: \code{0.001}.}

\item{AE.reg.alpha}{The LTMG regularized intensity. Default: \code{0.5}.}

\item{use.VGAE}{Whether to use Variational Graph AutoEncoder (VGAE). Default: \code{TRUE}.}

\item{GAE.epochs}{The number of epoch for the GAE. Default: \code{300}.}

\item{GAE.learning.rate}{Initial learning rate of GAE. Default: \code{0.01}.}

\item{cell_val_ratio}{For GAE that construct cell-cell association networks, the proportion of edges that are extracted as the validation set. Default: \code{0.05}.}

\item{gene_val_ratio}{As with parameter \code{cell_val_ratio}, it is simply applied with the construction of gene-gene association networks.}

\item{parallel}{Whether to use multiple processors to run GAE. Default: \code{FALSE} When \code{parallel=TRUE} (default), tow processors will be used to run GAE.}

\item{seed}{Random number generator seed.}

\item{verbose}{Gives information about each step. Default: \code{TRUE}.}
}
\value{
A list:
\describe{
  \item{cell_network}{Constructed cell association network.}
  \item{gene_network}{Constructed gene association network.}
  \item{cell_gene_network}{Constructed gene-cell association network.}
}
}
\description{
This function implements a graph neural network with two autoencoders. 1. AutoEncoder (AE) based on deep neural network:
Infer latent associations between genes and cells. 2. Graph AutoEncoder (GAE) based on graph convolutional neural network: Construct
association networks for gene-gene, cell-cell.
}
\details{
ConNetGNN


The \code{ConNetGNN} function establishes a graph neural network (GNN) framework to mine latent relationships between genes and cells and within themselves.
This framework mainly includes two capabilities: \itemize{
\item 1.Deep neural network-based AutoEncoder inferring associations between genes and cells and generating gene features and cell features for the GAE.
\item 2.The GAE takes the gene feature and cell feature as the node features of the initial gene correlation network and cell correlation network,
and constructs the gene association network and cell association network through the graph convolution process.
}

The GNN is implemented based on \code{pytorch}, so an appropriate python environment is required:
\itemize{
\item python >=3.9.7
\item pytorch >=1.10.0
\item sklearn >=0.0
\item scipy >=1.7.3
\item numpy >=1.19.5
}

If the user has already configured the python environment, the path of the python binary file can be directly entered into \code{python.path}.
If the parameter \code{python.path} is NULL, the program will build a miniconda environment called \code{scapGNN_env} and configure python.
We also provide environment files for conda: \code{/inst/extdata/scapGNN_env.yaml}. Users can install it with the command: \code{conda env create -f scapGNN_env.yaml}.
}
\examples{
require(coop)
require(reticulate)
require(parallel)
# Data preprocessing
data("Hv_exp")
Prep_data <- Preprocessing(Hv_exp[1:300,])
\dontrun{
# Specify the python path
ConNetGNN_data <- ConNetGNN(Prep_data,python.path="../miniconda3/envs/scapGNN_env/python.exe")
}

}
