% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{heatFilter}
\alias{heatFilter}
\title{Graph filter with the heat kernel: \deqn{f(x) = exp(-\beta |x / \lambda_m - a|^b)}}
\usage{
heatFilter(x, l.max, order = 1, offset = 0, beta = 30)
}
\arguments{
\item{x}{numeric Values to be filtered. Normally, these are graph laplacian engenvalues.}

\item{l.max}{numeric Maximum eigenvalue on the graph (\eqn{\lambda_m} in the equation)}

\item{order}{numeric Parameter \eqn{b} in the equation. Larger values correspond to the sharper kernel form (default=1). The values should be positive.}

\item{offset}{numeric Mean kernel value (\eqn{a} in the equation), must be in [0:1] (default=0)}

\item{beta}{numeric Parameter \eqn{\beta} in the equation. Larger values provide stronger smoothing. \eqn{\beta=0} corresponds to no smoothing (default=30).}
}
\value{
smoothed values for `x`
}
\description{
Graph filter with the heat kernel: \deqn{f(x) = exp(-\beta |x / \lambda_m - a|^b)}
}
\seealso{
Other graph smoothing: 
\code{\link{computeChebyshevCoeffs}()},
\code{\link{smoothChebyshev}()},
\code{\link{smoothSignalOnGraph}()}
}
\concept{graph smoothing}
