% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{SpectralShift}
\alias{SpectralShift}
\title{Performs the spectral shift on a matrix to make it numerically positive definite.}
\usage{
SpectralShift(L, threshold = 1e-10)
}
\arguments{
\item{L}{A square numeric matrix.}

\item{threshold}{The eigenvalue threshold. Default 1E-10.}
}
\value{
The spectral-shifted matrix.
}
\description{
Matrix \code{L} is assumed to have eigenvalues that are either all positive, or very
close to zero.  If any eigenvalues are less than less than \code{threshold}, a positive
quantity is added to the diagonal.
}
\keyword{internal}
