% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color-spaces.R
\name{lab_to_xyz}
\alias{lab_to_xyz}
\title{Convert from Lab space to XYZ colour channels.}
\usage{
lab_to_xyz(lab)
}
\arguments{
\item{lab}{A dataframe or matrix with L, a and b colour channels located in the columns 1 to 3, respectively.}
}
\value{
A \code{tibble} of X, Y and Z colour channels.
}
\description{
Convert from Lab space to XYZ colour channels.
}
\examples{
l <- sample(x = 40:60, size = 10, replace = TRUE)
a <- sample(x = -128:128, size = 10, replace = TRUE)
b <- sample(x = -128:128, size = 10, replace = TRUE)
lab_to_xyz(data.frame(l = l, a = a, b = b))
}
