% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel_extract.R
\name{read_xl_format}
\alias{read_xl_format}
\title{Read Formatting of All Sheets in an Excel Workbook}
\usage{
read_xl_format(file_name = NULL)
}
\arguments{
\item{file_name}{(character) Name of (and path to) the Excel workbook}
}
\value{
(data frame) One row per cell in the dataframe with a column for each type of relevant formatting and its 'address' within the original Excel workbook
}
\description{
Retrieves all sheets of a Microsoft Excel workbook and identifies the formatting of each value (including column headers and blank cells).
}
\examples{
# Identify the formatting of every cell in all sheets of an Excel file
read_xl_format(file_name = system.file("extdata", "excel_book.xlsx", package = "scicomptools"))

}
