% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tests.R
\name{wilcoxonSignedTest}
\alias{wilcoxonSignedTest}
\title{Wilcoxon signed-rank est}
\usage{
wilcoxonSignedTest(x, y, ...)
}
\arguments{
\item{x}{First sample}

\item{y}{Second sample}

\item{...}{Ignored}
}
\value{
A list with class "htest" containing the following components: \code{statistic}, the value of the statistic used in the test; \code{p.value}, the p-value for the test; \code{method}, a character string indicating what type of test was performed and \code{data.name}, a character string giving the name of the data.
}
\description{
This function implements the paired Wilcoxon signed-rank test
}
\details{
The test has been implemented according to the version in Demsar (2006), page 7
}
\examples{
x <- rbeta(50, 2, 20)
y <- x + runif(50) * 0.2
wilcoxonSignedTest(x, y)
}
\references{
Demsar, J. (2006) Statistical Comparisons of Classifiers over Multiple Data Sets. \emph{Journal of Machine Learning Research}, 7, 1-30.
}

