% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-forecast.R
\name{as_forecast_generic}
\alias{as_forecast_generic}
\title{Common functionality for \verb{as_forecast_<type>} functions}
\usage{
as_forecast_generic(data, forecast_unit = NULL, ...)
}
\arguments{
\item{data}{A data.frame (or similar) with predicted and observed values.
See the details section of for additional information
on the required input format.}

\item{forecast_unit}{(optional) Name of the columns in \code{data} (after
any renaming of columns) that denote the unit of a
single forecast. See \code{\link[=get_forecast_unit]{get_forecast_unit()}} for details.
If \code{NULL} (the default), all columns that are not required columns are
assumed to form the unit of a single forecast. If specified, all columns
that are not part of the forecast unit (or required columns) will be removed.}

\item{...}{Named arguments that are used to rename columns. The names of the
arguments are the names of the columns that should be renamed. The values
are the new names.}
}
\description{
Common functionality for \verb{as_forecast_<type>} functions
}
\details{
This function splits out part of the functionality of
\verb{as_forecast_<type>} that is the same for all \verb{as_forecast_<type>} functions.
It renames the required columns, where appropriate, and sets the forecast
unit.
}
\keyword{as_forecast}
