% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grim-map-seq.R
\name{grim_map_seq}
\alias{grim_map_seq}
\title{GRIM-testing with dispersed inputs}
\usage{
grim_map_seq(
  data,
  x = NULL,
  n = NULL,
  var = .var,
  dispersion = .dispersion,
  out_min = .out_min,
  out_max = .out_max,
  include_reported = .include_reported,
  include_consistent = .include_consistent,
  ...
)
}
\arguments{
\item{data}{A data frame that \code{grim_map()} could take.}

\item{x, n}{Optionally, specify these arguments as column names in \code{data}.}

\item{var}{String. Names of the columns that will be dispersed. Default is
\code{c("x", "n")}.}

\item{dispersion}{Numeric. Sequence with steps up and down from the \code{var}
inputs. It will be adjusted to these values' decimal levels. For example,
with a reported \code{8.34}, the step size is \code{0.01}. Default is \code{1:5}, for five
steps up and down.}

\item{out_min, out_max}{If specified, output will be restricted so that it's
not below \code{out_min} or above \code{out_max}. Defaults are \code{"auto"} for
\code{out_min}, i.e., a minimum of one decimal unit above zero; and \code{NULL} for
\code{out_max}, i.e., no maximum.}

\item{include_reported}{Boolean. Should the reported values themselves be
included in the sequences originating from them? Default is \code{FALSE} because
this might be redundant and bias the results.}

\item{include_consistent}{Boolean. Should the function also process
consistent cases (from among those reported), not just inconsistent ones?
Default is \code{FALSE} because the focus should be on clarifying
inconsistencies.}

\item{...}{Arguments passed down to \code{grim_map()}.}
}
\value{
A tibble (data frame) with detailed test results.
}
\description{
\code{grim_map_seq()} performs GRIM-testing with values surrounding
the input values. This provides an easy and powerful way to assess whether
small errors in computing or reporting may be responsible for
GRIM-inconsistencies in published statistics.

Call \code{audit_seq()} on the results for summary statistics.
}
\section{Summaries with \code{audit_seq()}}{
 You can call \code{audit_seq()} following
\code{grim_map_seq()}. It will return a data frame with these columns:
\itemize{
\item \code{x} and \code{n} are the original inputs,
tested for \code{consistency} here.
\item \code{hits_total} is the total number of GRIM-consistent value sets
found within the specified \code{dispersion} range.
\item \code{hits_x} is the number of GRIM-consistent value sets
found by varying \code{x}.
\item Accordingly with \code{n} and \code{hits_n}.
\item (Note that any consistent reported cases will be counted by the
\verb{hits_*} columns if both \code{include_reported} and \code{include_consistent}
are set to \code{TRUE}.)
\item \code{diff_x} reports the absolute difference between \code{x} and the next
consistent dispersed value (in dispersion steps, not the actual numeric
difference). \code{diff_x_up} and \code{diff_x_down} report the difference to the
next higher or lower consistent value, respectively.
\item \code{diff_n}, \code{diff_n_up},   and \code{diff_n_down} do the same for \code{n}.
}
}

\examples{
# `grim_map_seq()` can take any input
# that `grim_map()` can take:
pigs1

# All the results:
out <- grim_map_seq(pigs1, include_consistent = TRUE)
out

# Case-wise summaries with `audit_seq()`
# can be more important than the raw results:
audit_seq(out)
}
