% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapper-function-helpers.R
\name{manage_key_colnames}
\alias{manage_key_colnames}
\title{Enable name-independent key column identification}
\usage{
manage_key_colnames(data, arg, description = NULL)
}
\arguments{
\item{data}{The mapper function's input data frame.}

\item{arg}{Symbol. The quoted input variable, captured by \code{rlang::enexpr()}.}

\item{description}{String (length 1). Short description of the column in
question, to be inserted into an error message.}
}
\value{
The input data frame, \code{data}, possibly modified.
}
\description{
A handwritten mapper function for consistency tests, such as
\code{grim_map()}, may include arguments named after the key columns in its
input data frame. When such an argument is specified by the user as a
column name of the input data frame, it identifies a differently-named
column as that key column.

Create such functionality in three steps:
\enumerate{
\item Add arguments to your mapper function named after the respective key
columns. They should be \code{NULL} by default; e.g., \verb{x = NULL, n = NULL}.
\item Within the mapper, capture the user input by quoting it using
\code{rlang::enexpr()}. Reassign these values to the argument variables; e.g.,
\code{x <- rlang::enexpr(x)} and \code{n <- rlang::enexpr(n)}.
\item For every such argument, call \code{manage_key_colnames()} and reassign its
value to the input data frame variable, adding a short description;
e.g.,\code{data <- manage_key_colnames(data, x, "mean/proportion")} and \code{data <-   manage_key_colnames(data, n, "sample size")}.
}
}
\seealso{
\code{vignette("consistency-tests")}, for context.
}
