% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicate-detect.R
\name{duplicate_tally}
\alias{duplicate_tally}
\title{Count duplicates at each observation}
\usage{
duplicate_tally(x, ignore = NULL, colname_end = "n")
}
\arguments{
\item{x}{Vector or data frame.}

\item{ignore}{Optionally, a vector of values that should not be checked. In
the test result columns, they will be marked \code{NA}.}

\item{colname_end}{String. Name ending of the logical test result columns.
Default is \code{"n"}.}
}
\value{
A tibble (data frame). It has all the columns from \code{x}, and to each
of these columns' right, the corresponding tally column.

The tibble has the \code{scr_dup_detect} class, which is recognized by the
\code{audit()} generic.
}
\description{
For every value in a vector or data frame, \code{duplicate_tally()}
counts how often it appears in total. Tallies are presented next to each
value.

For summary statistics, call \code{\link[=audit]{audit()}} on the results.
}
\details{
This function is not very informative with many input values that
only have a few characters each. Many of them may have duplicates just by
chance. For example, in R's built-in \code{iris} data set, 99\% of values have
duplicates.

In general, the fewer values and the more characters per value, the more
significant the results.
}
\section{Summaries with \code{\link[=audit]{audit()}}}{
 There is an S3 method for the \code{\link[=audit]{audit()}}
generic, so you can call \code{\link[=audit]{audit()}} following \code{duplicate_tally()}. It
returns a tibble with summary statistics.
}

\examples{
# Tally duplicate values in a data frame...
duplicate_tally(x = pigs4)

# ...or in a single vector:
duplicate_tally(x = pigs4$snout)

# Summary statistics with `audit()`:
pigs4 \%>\%
  duplicate_tally() \%>\%
  audit()

# Any values can be ignored:
pigs4 \%>\%
  duplicate_tally(ignore = c(8.131, 7.574))
}
\seealso{
\itemize{
\item \code{\link[=duplicate_count]{duplicate_count()}} for a frequency table.
\item \code{\link[=duplicate_count_colpair]{duplicate_count_colpair()}} to check each combination of columns for
duplicates.
\item \code{\link[janitor:get_dupes]{janitor::get_dupes()}} to search for duplicate rows.
}
}
