% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_model}
\alias{plot_model}
\title{Plot observed UMI counts and model}
\usage{
plot_model(
  x,
  umi,
  goi,
  x_var = x$arguments$latent_var[1],
  cell_attr = x$cell_attr,
  do_log = TRUE,
  show_fit = TRUE,
  show_nr = FALSE,
  plot_residual = FALSE,
  batches = NULL,
  as_poisson = FALSE,
  arrange_vertical = TRUE,
  show_density = TRUE,
  gg_cmds = NULL
)
}
\arguments{
\item{x}{The output of a vst run}

\item{umi}{UMI count matrix}

\item{goi}{Vector of genes to plot}

\item{x_var}{Cell attribute to use on x axis; will be taken from x$arguments$latent_var[1] by default}

\item{cell_attr}{Cell attributes data frame; will be taken from x$cell_attr by default}

\item{do_log}{Log10 transform the UMI counts in plot}

\item{show_fit}{Show the model fit}

\item{show_nr}{Show the non-regularized model (if available)}

\item{plot_residual}{Add panels for the Pearson residuals}

\item{batches}{Manually specify a batch variable to break up the model plot in segments}

\item{as_poisson}{Fix model parameter theta to Inf, effectively showing a Poisson model}

\item{arrange_vertical}{Stack individual ggplot objects or place side by side}

\item{show_density}{Draw 2D density lines over points}

\item{gg_cmds}{Additional ggplot layer commands}
}
\value{
A ggplot object
}
\description{
Plot observed UMI counts and model
}
\examples{
\dontrun{
vst_out <- vst(pbmc, return_cell_attr = TRUE)
plot_model(vst_out, pbmc, 'PPBP')
}

}
