% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_import.R
\name{hier_import}
\alias{hier_import}
\title{Imports a nested data structure}
\usage{
hier_import(inp, from = "json", root = NULL)
}
\arguments{
\item{inp}{an import from which should be converted. This could either
be a character-string (json) or a \code{data.frame}.}

\item{from}{(character) from which format should be imported.
Possible choices are:
\itemize{
\item \strong{"json"}: json-encoded string should be converted
\item \strong{"df"}: a \code{data.frame} in \code{@;level}-format will
be converted
\item \strong{"dt"}: a \code{data.table} in \code{@;level}-format will
be converted
\item \strong{"argus"}: an object exported using \code{\link{hier_convert}}
using \code{as = "argus"}
\item \strong{"code"}: an object exported using \code{\link{hier_convert}}
using \code{as = "code"}
\item \strong{"hrc"}: text-files in tau-argus hrc-format
\item \strong{"sdc"}: an object exported using \code{\link{hier_convert}}
using \code{as = "sdc"}
}}

\item{root}{optional name of overall total}
}
\value{
a (nested) hierarchy
}
\description{
This function creates a nested sdc hierarchy from various
input structures.
}
\examples{
h <- hier_create(root = "Total", nodes = LETTERS[1:2])
h <- hier_add(h, root = "A", nodes = c("a1", "a2"))
h <- hier_add(h, root = "B", nodes = c("b1", "b2"))
h <- hier_add(h, root = "b1", nodes = "b1a")
hier_display(h)

df <- hier_convert(h, as = "df")
hier_display(df)

h2 <- hier_import(df, from = "df")
hier_display(h2)
}
