% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalRecode.R
\docType{methods}
\name{globalRecode}
\alias{globalRecode}
\title{Global Recoding}
\usage{
globalRecode(obj, ...)
}
\arguments{
\item{obj}{a numeric vector, a \code{data.frame} or an object of class
\code{\link{sdcMicroObj-class}}}

\item{...}{see possible arguments below
\itemize{
\item{column: }{which keyVar should be changed. Character vector of length 1 specifying the variable name that
should be recoded (required if \code{obj} is a \code{data.frame} or
an object of class \code{\link{sdcMicroObj-class}}.}
\item{breaks: }{either a numeric vector of cut points or number giving the
number of intervals which x is to be cut into.}
\item{labels: }{labels for the levels of the resulting category. By default,
labels are constructed using "(a,b]" interval notation.  If labels = FALSE,
simple integer codes are returned instead of a factor.}
\item{method: }{The following arguments are supported:
\itemize{
\item \dQuote{equidistant:} for equal sized intervalls
\item \dQuote{logEqui:} for equal sized intervalls for log-transformed data
\item \dQuote{equalAmount:} for intervalls with approxiomately the same amount
of observations
}}}}
}
\value{
the modified \code{\link{sdcMicroObj-class}} or a factor, unless labels = FALSE
which results in the mere integer level codes.
}
\description{
Global recoding of variables
}
\details{
If a labels parameter is specified, its values are used to name the factor
levels.  If none is specified, the factor level labels are constructed.
}
\note{
\code{globalRecode} can not be applied to vectors stored as factors from sdcMicro >= 4.7.0!
}
\examples{
data(free1)
free1 <- as.data.frame(free1)

## application to a vector
head(globalRecode(free1$AGE, breaks=c(1,9,19,29,39,49,59,69,100), labels=1:8))
table(globalRecode(free1$AGE, breaks=c(1,9,19,29,39,49,59,69,100), labels=1:8))

## application to a data.frame
# automatic labels
table(globalRecode(free1, column="AGE", breaks=c(1,9,19,29,39,49,59,69,100))$AGE)

## calculation of brea-points using different algorithms
table(globalRecode(free1$AGE, breaks=6))
table(globalRecode(free1$AGE, breaks=6, method="logEqui"))
table(globalRecode(free1$AGE, breaks=6, method="equalAmount"))

## for objects of class sdcMicro:
data(testdata2)
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- globalRecode(sdc, column="water", breaks=3)
table(get.sdcMicroObj(sdc, type="manipKeyVars")$water)
}
\references{
Templ, M. and Kowarik, A. and Meindl, B.
Statistical Disclosure Control for Micro-Data Using the R Package sdcMicro.
\emph{Journal of Statistical Software}, \strong{67} (4), 1--36, 2015. \doi{10.18637/jss.v067.i04}

Templ, M. Statistical Disclosure Control for Microdata: Methods and Applications in R.
\emph{Springer International Publishing}, 287 pages, 2017. ISBN 978-3-319-50272-4. \doi{10.1007/978-3-319-50272-4}
\doi{10.1007/978-3-319-50272-4}
}
\seealso{
\code{\link{cut}}
}
\author{
Matthias Templ and Bernhard Meindl
}
\keyword{manip}
