% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enterprises.R
\docType{data}
\name{enterprises}
\alias{enterprises}
\title{Simulated data set with enterprise locations.}
\format{An object of class \code{SpatialPointsDataFrame} with 8348 rows and 2 columns.}
\usage{
enterprises
}
\description{
\code{enterprises} is generated from the dutch open data
\href{https://zakelijk.kadaster.nl/bag-producten}{BAG register}.
The locations are realistic, but the associated data is simulated.
}
\details{
\itemize{
\item \code{production} \code{\link{numeric}} simulated production (lognormal).
\item \code{fined} \code{\link{logical}} simulated variable if an enterprise is fined or not.
}
}
\examples{
library(sdcSpatial)
library(raster)

data("enterprises")

production <- sdc_raster(enterprises, "production", min_count = 10)
print(production)

# show the average production per cell
plot(production, "mean")
production$min_count <- 2 # adjust norm for sdc
plot(production)

production_safe <- remove_sensitive(production)
plot(production_safe)
}
\references{
Basisregistratie Adressen en Gebouwen: \url{https://zakelijk.kadaster.nl/bag-producten}
}
\keyword{datasets}
