% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_multiple.r, R/methods_multiple_classes.r
\docType{methods}
\name{calc.multiple}
\alias{calc.multiple}
\alias{calc.multiple,character,list-method}
\title{perform calculations on multiple objects depending on argument \code{type}}
\usage{
calc.multiple(type, input)

\S4method{calc.multiple}{character,list}(type, input)
}
\arguments{
\item{type}{a character vector of length 1 defining what to calculate|return|modify. Allowed types are:}
\itemize{
\item makePartitions: information on subtables required for HITAS and HYPECUBE algorithms
\item genMatMFull: the constraint matrix used in the master problem
\item makeAttackerProblem: set up the attackers problem for a given (sub)table
\item calcFullProblem: calculate a complete problem object containing all information required to solve the secondary cell suppression problem}

\item{input}{a list depending on argument \code{type}.}
\itemize{
\item if type matches 'makePartitions', 'genMatMFull' or 'makeAttackerProblem': a list of length 2 with elements 'objectA' and 'objectB'
\itemize{
\item element 'object A': an object of class \code{problemInstance}
\item element 'object B': an object of class \code{dimInfo} }
\item type matches 'calcFullProblem': a list of length 1
\itemize{
\item element 'object A': an object of class \code{dataObj}
\item element 'object B': an object of class \code{dimInfo} }}
}
\value{
manipulated data based on argument \code{type}
\itemize{
\item list with elements 'groups', 'indices', 'strIDs', 'nrGroups' and 'nrTables' if argument \code{type} matches 'makePartitions'
\item object of class \code{simpleTriplet} if argument \code{type} matches 'genMatMFull'
\item object of class \code{linProb} if argument \code{type} matches 'makeAttackerProblem'
\item object of class \code{sdcProblem} if argument \code{type} matches 'calcFullProblem'
}
}
\description{
perform calculations on multiple objects depending on argument \code{type}
}
\note{
internal function
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}

