% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name.R
\name{gen_lastname}
\alias{gen_lastname}
\title{Randomly generate a lastname.}
\usage{
gen_lastname(country = "uk", race = NA)
}
\arguments{
\item{country}{A string variable with a default of 'uk'. It is either
'uk' or 'us'.}

\item{race}{A number or a string of the ethnicity code:
1 American Indian or Native Alaskan, 2 Asian or Pacific Islander,
3 Black (not Hispanic), 4 Hispanic, 5 White (not Hispanic) and
6 Middle-Eastern, Arabic.}
}
\value{
A name string.
}
\description{
\code{gen_lastname} randomly sample a lastname from the selected database:
    \enumerate{
    \item \code{country} If is 'uk', the function will automatically sample a
    lastname. from a extracted lastname database. The lastname database was extracted
    from ONS.
    \item If \code{country} is 'us', the function will automatically sample a
    lastname. that based on the \code{race}. The us lastname database was extracted
    from \code{\link[randomNames:randomNamesData]{randomNamesData}}.
    }
}
\examples{
gen_lastname(country = "uk")
gen_lastname(country = "us", race = 2)
gen_lastname(country = "us", race = 'Hispanic')

}
