% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd_df.R
\name{mutate.cnd_df}
\alias{mutate.cnd_df}
\title{Mutate method for conditioned data frames}
\usage{
\method{mutate}{cnd_df}(
  .data,
  ...,
  .by = NULL,
  .keep = c("all", "used", "unused", "none"),
  .before = NULL,
  .after = NULL
)
}
\arguments{
\item{.data}{A conditioned data frame.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Name-value pairs.
The name gives the name of the column in the output.

The value can be:
\itemize{
\item A vector of length 1, which will be recycled to the correct length.
\item A vector the same length as the current group (or the whole data frame
if ungrouped).
\item \code{NULL}, to remove the column.
\item A data frame or tibble, to create multiple columns in the output.
}}

\item{.by}{Not used when \code{.data} is a conditioned data frame.}

\item{.keep}{Control which columns from \code{.data} are retained in the output. Grouping
columns and columns created by \code{...} are always kept.
\itemize{
\item \code{"all"} retains all columns from \code{.data}. This is the default.
\item \code{"used"} retains only the columns used in \code{...} to create new
columns. This is useful for checking your work, as it displays inputs
and outputs side-by-side.
\item \code{"unused"} retains only the columns \emph{not} used in \code{...} to create new
columns. This is useful if you generate new columns, but no longer need
the columns used to generate them.
\item \code{"none"} doesn't retain any extra columns from \code{.data}. Only the grouping
variables and columns created by \code{...} are kept.
}}

\item{.before}{Not used, use \code{.after} instead.}

\item{.after}{Control where new columns should appear, i.e. after which
columns.}
}
\value{
A conditioned data frame, meaning a tibble with mutated values.
}
\description{
\code{\link[=mutate.cnd_df]{mutate.cnd_df()}} is an S3 method to be dispatched by \link[dplyr:mutate]{mutate}
generic on conditioned data frames. This function implements a conditional
mutate by only changing rows for which the condition stored in the
conditioned data frame is \code{TRUE}.
}
