% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd_df.R
\name{new_cnd_df}
\alias{new_cnd_df}
\title{Create a data frame with filtering tags}
\usage{
new_cnd_df(dat, cnd, .warn = TRUE)
}
\arguments{
\item{dat}{A data frame.}

\item{cnd}{A logical vector. Length must match the number of rows in \code{dat}.}

\item{.warn}{Whether to warn about creating a new \emph{conditioned} data frame
in case that \code{dat} already is one.}
}
\value{
A data frame \code{dat} with the additional class \code{"cnd_df"} and the
following attributes:
\itemize{
\item \code{cnd}: The logical vector passed as argument \code{cnd}: \code{TRUE} values mark
rows in \code{dat} to be used for transformations; rows marked with \code{FALSE} are
not transformed; and \code{NA} mark rows whose transformations are to be applied
resulting in \code{NA}.
\item \code{cnd_sum}: An integer vector of three elements providing the sum of \code{TRUE},
\code{FALSE} and \code{NA} values in \code{cnd}, respectively.
}
}
\description{
\code{\link[=new_cnd_df]{new_cnd_df()}} creates a \emph{conditioned} data frame, classed \code{cnd_df}, meaning
that this function extends the data frame passed as argument by storing a
logical vector \code{cnd} (as attribute) that marks rows for posterior conditional
transformation by methods that support \emph{conditioned} data frames.
}
\seealso{
\code{\link[=is_cnd_df]{is_cnd_df()}}, \code{\link[=get_cnd_df_cnd]{get_cnd_df_cnd()}}, \code{\link[=get_cnd_df_cnd_sum]{get_cnd_df_cnd_sum()}},
\code{\link[=rm_cnd_df]{rm_cnd_df()}}.
}
\keyword{internal}
