% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd_df.R
\name{condition_add}
\alias{condition_add}
\title{Add filtering tags to a data set}
\usage{
condition_add(dat, ..., .na = NA, .dat2 = rlang::env())
}
\arguments{
\item{dat}{A data frame.}

\item{...}{Conditions to filter the data frame.}

\item{.na}{Return value to be used when the conditions evaluate to \code{NA}.}

\item{.dat2}{An optional environment to look for variables involved in
logical expression passed in \code{...}. A data frame or a list can also be
passed that will be coerced to an environment internally.}
}
\value{
A conditioned data frame, meaning a tibble with an additional class
\code{cnd_df} and a logical vector attribute indicating matching rows.
}
\description{
\code{condition_add()} tags records in a data set, indicating which rows match the
specified conditions, resulting in a conditioned data frame. Learn how to
integrate conditioned data frames in your SDTM domain derivation in
\code{vignette("cnd_df")}.
}
\examples{
(df <- tibble::tibble(x = 1L:3L, y = letters[x]))

# Mark rows for which `x` greater than `1`
(cnd_df <- condition_add(dat = df, x > 1L))

}
