% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/inspect.R
\name{inspect}
\alias{inspect}
\title{Interactively Inspect a Seasonal Adjustment Model}
\usage{
inspect(x, fun = NULL, launch.browser = getOption("shiny.launch.browser",
  interactive()))
}
\arguments{
\item{x}{an object of class \code{"seas"}}

\item{fun}{a function or a list of functions (see details)}

\item{launch.browser}{how to open the app. Argument passed on to
\code{\link[shiny]{runApp}}.}
}
\description{
Interactively inspect a \code{"seas"} object. The goal of \code{inspect} is
to summarize all relevant options, plots and statistics that should be
usually considered.
}
\details{
The \code{inspect} function opens an interactive window that allows for the
manipulation of a number of arguments. It offers several views to analyze the
series graphically. With each change, the adjustment process and the
visualizations are recalculated.

Summary statistics are shown in the first tab. The last tab offers access to
all series that can be produced with X-13.

The views in \code{inspect} may be customized via the \code{fun} argument.
One or several plot functions may be supplied. The plot functions should have
a \code{"seas"} object as their only argument. Several functions must be
wrapped in a list (see examples).
}
\examples{
\dontrun{

m <- seas(AirPassengers)

inspect(m)


### customizing inspect

# a single function
fc <- function(m){
  ts.plot(series(m, "fct", verbose = FALSE))
}
inspect(m, fc)

# more than one function collected in a list
myfun <- list()
myfun[['Spectum X-13']] <- function(m){
  plot(series(m, "spectrum.specorig", verbose = FALSE)[,-1], t = "l")
}
myfun[['Spectum R']] <- function(m){
  spectrum(diff(log(AirPassengers)), method = "ar")
}
inspect(m, myfun)

# and a bonus example
spaghetti <- function(m, back = 10){
ser <- original(m)
tx <- time(ser)[(length(ser) - back):length(ser)]
z <- NULL
for (txi in tx){
  assign(as.character(m$call$x), window(ser, end = txi))
  z <- cbind(z, final(eval(m$call)))
}
ts.plot(window(z, start = time(ser)[(length(ser) - back- 15)]),
        col = rainbow(back + 1))
}
inspect(m, spaghetti)

}
}
\seealso{
\code{\link{seas}} for the main function of seasonal.
}

