% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cenScatPlot.R
\name{cenScatPlot}
\alias{cenScatPlot}
\title{Scatter plot of water-quality data}
\usage{
cenScatPlot(
  data,
  datescol = "dates",
  pname,
  qwcols = c("R", "P"),
  site = "",
  xlabel = "",
  ylabel = "Concentration",
  legpos = "topright",
  legcex = 1,
  ...
)
}
\arguments{
\item{data}{is the dataset with columns that begin with P followed 
by alphanumeric characters indicating concentration data and columns 
that begin with R followed by alphanumeric characters that match those 
of the concentration data indicating qualification codes. See example 
datasets for more information about the data format, see 
\code{\link{IllRivValleyCty}} and \code{\link{qwMoRivOmaha}}.}

\item{datescol}{is the column label for the dates column.}

\item{pname}{is the column heading (parameter name) for the 
particular water-quality constituent to be plotted (omit 
the  starting character, for example for sulfate data indicated by 
P00945, enter "00945").}

\item{qwcols}{is a character vector with the beginning of the
column headers for remarks code (default is R), and beginning of 
column headers for concentration data (default is P for parameter).}

\item{site}{is a label for the plot title indicating the site where
the water-quality samples were collected.}

\item{xlabel}{is the label for the x-axis, defaults to no label.}

\item{ylabel}{is the label for the y-axis.}

\item{legpos}{is the position of the legend, see \link{legend}.}

\item{legcex}{is a numerical value giving the amount by which the 
legend text and symbols should be magnified relative to the default, 
1.}

\item{...}{arguments to be passed to \link{plot} method.}
}
\value{
A scatter plot
}
\description{
Function to generate a scatter plot that indicates censored and 
estimated water-quality concentrations.
}
\details{
This function uses the qualification, or remark, column associated
with water-quality concentration values to indicate which samples are 
unqualified, which are estimated, and which are censored.
A blank remark field or an "_" indicates that the concentration 
value is not qualified; an "E" indicates the value has been 
estimated; and a less than symbol, "<", indicates the value has been 
censored as less than a minimum reporting level.  See Oblinger 
Childress and others (1999) for information on the minimum reporting level 
and the definition of "E" for U.S. Geological Survey data.  Other users may 
have a different definition of the minimum reporting level, but 
censored values need to be qualified with a "<".  Using the "E" code is 
optional.
}
\examples{
data(swData)
# scatter plot of Simazine concentrations
cenScatPlot(IllRivValleyCty, pname = "04035")
# scatter plot with many additional plotting arguments
par(las = 1, tcl = 0.5)
cenScatPlot(IllRivValleyCty, pname = "04035", 
            site = "05586100 Illinois River at Valley City, IL",
            ylabel = "Simazine concentration, in micrograms per liter", 
            legcex = 0.7, ylim = c(0, 0.4), yaxs = "i", cex.lab = 0.9, 
            cex.axis = 0.9, xlim = c(as.Date("1996-01-01", "\%Y-\%m-\%d"), 
            as.Date("2012-01-01", "\%Y-\%m-\%d")), xaxs = "i", xaxt = "n")
axdates <- c("1996-01-01", "2000-01-01", "2004-01-01", "2008-01-01",
           "2012-01-01")
axis(1, as.Date(axdates, "\%Y-\%m-\%d"), 
     labels = c("1996", "2000", "2004", "2008", "2012"), cex.axis = 0.9)
}
\references{
Oblinger Childress, C.J., Foreman, W.T., Connor, B.F., and Maloney, 
T.J., 1999, New reporting procedures based on long-term method 
detection levels and some considerations for interpretations of 
water-quality data provided by the U.S. Geological Survey: U.S. 
Geological Survey Open-File Report 99--193, 19 p.,
\url{https://water.usgs.gov/owq/OFR_99-193/index.html}.
}
\author{
Karen R. Ryberg
}
\keyword{hplot}
