% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CellCycle.R
\docType{data}
\name{CellCycle}
\alias{CellCycle}
\title{Cell cycle data}
\format{A list with two components: 
\describe{
  \item{X}{Chromatin immunoprecipitation data, a matrix of 1790 rows and 113 columns.}
  \item{Y}{Eukariotic cell cycle data, a matrix of 1790 rows and 18 columns.}
}}
\usage{
data(CellCycle)
}
\description{
A list of two matrices used in Lee (2002).
}
\details{
Matrix X, the chromatin immunoprecipitation (ChIP) data contain complete binding 
information of a subset of 1790 genes for a total of 113 transcription 
factors.

Matrix Y, the Eukariotic cell cycle data were generated using alpha factor arrest method,
consisting of RNA levels measured every 7 minutes for 119 minutes with a total 
of 18 time points covering two cell cycle of 1790 genes.
}
\examples{
# data(CellCycle)
# X <- CellCycle$X;Y <- CellCycle$Y
# n <- nrow(Y); p <- ncol(X); q <-  ncol(Y)
# control <- secure.control(spU=160/p,spV=1)
# fit.cycle <- secure.path(Y, X, nrank = 10, nlambda = 100,
#                   control = control)
}
\references{
Lee, T. I., Rinaldi, N. J., Robert, F., Odom, D. T., Bar-Joseph, Z., Gerber, G. K., 
Hannett, N. M., Harbison, C. T., Thompson, C. M., Simon, I. et al. (2002) \emph{Transcriptional
regulatory networks in saccharomyces cerevisiae. Science, 298, 799-804}.
}
\keyword{datasets}

