% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.check_heteroscedasticity.R
\name{plot.see_check_heteroscedasticity}
\alias{plot.see_check_heteroscedasticity}
\title{Plot method for (non-)constant error variance checks}
\usage{
\method{plot}{see_check_heteroscedasticity}(
  x,
  data = NULL,
  size_point = 2,
  linewidth = 0.8,
  size_title = 12,
  size_axis_title = base_size,
  base_size = 10,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{data}{The original data used to create this object. Can be a
statistical model.}

\item{size_point}{Numeric specifying size of point-geoms.}

\item{linewidth}{Numeric value specifying size of line geoms.}

\item{base_size, size_axis_title, size_title}{Numeric value specifying size of
axis and plot titles.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the
\code{performance::check_heteroscedasticity()} function.
}
\examples{
m <- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
result <- performance::check_heteroscedasticity(m)
result
plot(result, data = m) # data required for pkgdown
}
\seealso{
See also the vignette about \href{https://easystats.github.io/performance/articles/check_model.html}{\code{check_model()}}.
}
