% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.n_factors.R
\name{plot.see_n_factors}
\alias{plot.see_n_factors}
\title{Plot method for numbers of clusters to extract or factors to retain}
\usage{
\method{plot}{see_n_factors}(x, data = NULL, type = c("bar", "line", "area"), size = 1, ...)
}
\arguments{
\item{x}{An object.}

\item{data}{The original data used to create this object. Can be a
statistical model.}

\item{type}{Character vector, indicating the type of plot.
Options are three different shapes to illustrate the degree of consensus
between dimensionality methods for each number of factors;
\code{"bar"} (default) for a bar chart,
\code{"line"} for a horizontal point and line chart, or
\code{"area"} for an area chart (frequency polygon).}

\item{size}{Depending on \code{type}, a numeric value specifying size of bars,
lines, or segments.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{parameters::n_factors()} and \code{parameters::n_clusters()}
}
\examples{
\dontshow{if (require("parameters") && require("nFactors")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(mtcars)
result <- n_factors(mtcars, type = "PCA")
result

plot(result) # type = "bar" by default
plot(result, type = "line")
plot(result, type = "area")
\dontshow{\}) # examplesIf}
}
