% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TL.R
\docType{methods}
\name{TL}
\alias{TL}
\alias{TL-class}
\alias{TL-methods}
\alias{TL,ANY-method}
\title{Method to backtest VaR violation using the Traffic Light (TL) approach of Basel}
\usage{
TL(y, n = NULL, no_fail = NULL, VaR, VaR_level)

\S4method{TL}{ANY}(y, n = NULL, no_fail = NULL, VaR, VaR_level)
}
\arguments{
\item{y}{The time series to apply a VaR model (a single asset rerurn or portfolio return).}

\item{n}{If \code{y} is not provided, then insert sample size. Default is NULL.}

\item{no_fail}{If \code{y} is not provided, then insert number of fails. Default is NULL.}

\item{VaR}{The forecast VaR.}

\item{VaR_level}{The VaR level, typically 95\% or 99\%.}
}
\description{
A method that performs backtest for VaR models using the TL approach. According to Basel, a VaR model is deemed valid if the cumulative probability of observing up to
\eqn{n_f} failures is less than 0.95 (green zone) under the binomial distribution with \eqn{n} (sample size) and Var level as
the parameters. If the cumulative probability is between 0.95 and 0.9999 a VaR model is in yellow zone. Otherwise (>0.9999) a VaR model is in red zone.
}
\examples{
pw.CCC.obj = new("simMGarch")
pw.CCC.obj@d = 10
pw.CCC.obj@n = 1000
pw.CCC.obj@changepoints = c(250,750)
pw.CCC.obj = pc_cccsim(pw.CCC.obj)
y_out_of_sample = t(pw.CCC.obj@y[,900:1000])
w=rep(1/pw.CCC.obj@d,pw.CCC.obj@d) #an equally weighted portfolio
#VaR = quantile(t(pw.CCC.obj@y[,1:899])\%*\%w,0.05)
#ts.plot(y_out_of_sample\%*\%w,ylab="portfolio return");abline(h=VaR,col="red")
#TL(y=y_out_of_sample\%*\%w,VaR=rep(VaR,100),VaR_level = 0.95)
}
\references{
Basle Committee on Banking Supervision (1996). "Supervisory Framework for the Use of ‘Backtesting’ in Conjunction with the Internal Models Approach to Market Risk Capital Requirements".
}
