% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{selenium_server}
\alias{selenium_server}
\title{Download and start the Selenium server.}
\usage{
selenium_server(
  version = "latest",
  selenium_manager = TRUE,
  interactive = TRUE,
  verbose = TRUE,
  temp = TRUE,
  path = NULL,
  echo_cmd = FALSE,
  extra_args = c()
)
}
\arguments{
\item{version}{The version of Selenium Server to download and run. By
default, the latest major or minor release is used.}

\item{selenium_manager}{Whether to enable Selenium Manager, which will
automatically download any missing drivers. Defaults to \code{TRUE}.}

\item{interactive}{By default, if you don't have a version downloaded, you
will be prompted to confirm that you want to download it, and the function
will error if \code{\link[rlang:is_interactive]{rlang::is_interactive()}} returns \code{FALSE}. To allow this
function to work in a non-interactive setting, set this to \code{FALSE}.}

\item{verbose}{Passed into \code{\link[utils:download.file]{utils::download.file()}}. Note that setting this
to \code{FALSE} will \emph{not} disable the prompt if a file needs to be downloaded.}

\item{temp}{Whether to use a temporary directory to download the Selenium
Server \code{.jar} file. This will ensure that the file is deleted after it is
used, but means that you will have to redownload the file with every new
R session. If \code{FALSE}, the file is saved in your user data directory.}

\item{path}{The path where the downloaded Selenium Server \code{.jar} file will
be saved. Overrides \code{temp}.}

\item{echo_cmd}{Passed into \link[processx:process]{processx::process$new()}.}

\item{extra_args}{A character vector of extra arguments to pass into the
Selenium Server call.}
}
\value{
A \link[processx:process]{processx::process} object. Call \verb{<process>$kill()} to stop the
server.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Downloads the latest release of Selenium Server, and then runs it as a
background process. You must have Java installed for this command to work.
}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
server <- selenium_server(interactive = FALSE)

server$kill()
\dontshow{\}) # examplesIf}
}
\seealso{
The \href{https://ashbythorpe.github.io/selenium-r/index.html}{package website}
for more ways to start the Selenium server.
}
