% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semantic_dashboard.R
\name{dashboard_page}
\alias{dashboard_page}
\alias{dashboardPage}
\title{Create a dashboard.}
\usage{
dashboard_page(
  header,
  sidebar,
  body,
  title = "",
  suppress_bootstrap = TRUE,
  theme = NULL
)

dashboardPage(
  header,
  sidebar,
  body,
  title = "",
  suppress_bootstrap = TRUE,
  theme = NULL
)
}
\arguments{
\item{header}{Header of a dashboard.}

\item{sidebar}{Sidebar of a dashboard.}

\item{body}{Body of a dashboard.}

\item{title}{Title of a dashboard.}

\item{suppress_bootstrap}{There are some conflicts in CSS styles between SemanticUI and Bootstrap. For the time being it's better to suppress Bootstrap. If \code{TRUE} bootstrap dependency from \code{shiny} will be disabled.}

\item{theme}{Theme name or path. For possible options see \code{\link[shiny.semantic]{semanticPage}}.}
}
\value{
Dashboard.
}
\description{
Create a page with menu item sidebar and body containing tabs and other additional elements.
}
\section{Functions}{
\itemize{
\item \code{dashboardPage}: Create a dashboard (alias for \code{dashboard_page} for compatibility with \code{shinydashboard})
}}

\examples{
if(interactive()){

  library(shiny)
  library(semantic.dashboard)

  ui <- dashboardPage(
    dashboardHeader(color = "blue"),
    dashboardSidebar(side = "left", size = "thin", color = "teal",
                     sidebarMenu(
                       menuItem(tabName = "tab1", "Tab 1"),
                       menuItem(tabName = "tab2", "Tab 2"))),
    dashboardBody(tabItems(
      tabItem(tabName = "tab1", p("Tab 1")),
      tabItem(tabName = "tab2", p("Tab 2"))))
  )

  server <- function(input, output) {
  }

  shinyApp(ui, server)
}
}
