% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_results.R
\name{slope_analysis}
\alias{slope_analysis}
\title{Function for plotting a slope analysis for an interaction in a PLS model}
\usage{
slope_analysis(moderated_model, dv, moderator, iv,  leg_place)
}
\arguments{
\item{moderated_model}{A SEMinR model that contains an interaction.}

\item{dv}{The name of the dependant consutruct affected by the moderator (interaction term).}

\item{moderator}{The name of the moderator construct.}

\item{iv}{The name of the independant construct affected by the moderator.}

\item{leg_place}{The location of the legend, in order to make sure the legend does not
obscure the plot lines.}
}
\description{
\code{slope_analysis} generates an interaction plot for the effect of an antecedent
  on an outcome given a mediator variale.
}
\examples{
data(mobi)

# seminr syntax for creating measurement model
mobi_mm <- constructs(
composite("Image",        multi_items("IMAG", 1:5)),
composite("Expectation",  multi_items("CUEX", 1:3)),
composite("Value",        multi_items("PERV", 1:2)),
composite("Satisfaction", multi_items("CUSA", 1:3)),
interaction_term(iv = "Image", moderator = c("Expectation"), method = orthogonal))

# Structural model
#  note: interactions should be the names of its main constructs joined by a '*' in between.
mobi_sm <- relationships(
  paths(to = "Satisfaction",
        from = c("Image", "Expectation", "Value",
                 "Image*Expectation")))

# Load data, assemble model, and estimate
mobi_pls <- estimate_pls(data = mobi,
                         measurement_model = mobi_mm,
                         structural_model = mobi_sm)

slope_analysis(mobi_pls, "Satisfaction", "Expectation", "Image", "bottomright")

}
