% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event.R, R/semnar-package.R
\name{get_event.semnar}
\alias{get_event.semnar}
\alias{get_event}
\title{Get event information from a \code{\link{semnar}} object}
\usage{
\method{get_event}{semnar}(object)

get_event(object)
}
\arguments{
\item{object}{either an object an object of class \code{\link{semnar}}.}
}
\value{
A list of \code{\link{semnar_event}} objects, with the unique presenters in the \code{object}.
}
\description{
Get event information from a \code{\link{semnar}} object
}
\examples{
IK_warwick <- presenter(name = "Ioannis",
                       surname = "Kosmidis",
                       affiliation = "University of Warwick",
                       link = "https://www.ikosmidis.com")

YRM <- event(event = "Young Researchers' Meeting",
             country = "England",
             city = "Coventry",
             state = "NA",
             lon = -1.560843, lat = 52.384019,
             link = "https://warwick.ac.uk/fac/sci/statistics/news/yrm/",
             institution = "University of Warwick",
             department = "Department of Statistics",
             school = NA,
             venue = "Mathemtical Sciences Building",
             address = NA,
             postcode = NA)

out <- add_presentation(presenter = IK_warwick,
                        event = "A",
                        country = "Greece",
                        title = "S") |>
       add_presentation(presenter = IK_warwick,
                        event = "B",
                        city = "London",
                        country = "UK",
                        title = "T") |>
       add_presentation(presenter = IK_warwick,
                        event = YRM,
                        title = "U")
get_event(out)
}
\seealso{
\code{\link[=presenter]{presenter()}} \code{\link[=set_presenter]{set_presenter()}}
}
