% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2_order.R
\name{s2_order}
\alias{s2_order}
\title{Order S2 products.}
\usage{
s2_order(s2_prodlist = NULL, export_prodlist = TRUE, delay = 5,
  apihub = NA)
}
\arguments{
\item{s2_prodlist}{Named character: list of the products to be ordered,
in the format \code{safelist} (see \linkS4class{safelist}).
Alternatively, it can be the path of a JSON file exported by a previous
execution of \link{s2_order}, in case the user wants, for any reason, to
resubmit the order.}

\item{export_prodlist}{Logical or character: if TRUE (default),
the list of ordered products is saved in a JSON text file, so to be easily
retrievable at a later stage with \link{safe_is_online} or \link{s2_download};
if FALSE, no output files are generated.
It is also possible to pass the path of an existing folder in which the
JSON file will be saved (otherwise, a default path is used).}

\item{delay}{Numeric: time frame (in seconds) to leave between two
consecutive orders. Default is 5 seconds: use a higher value if you
encountered errors (i.e. not all the products were correctly ordered).}

\item{apihub}{Path of the "apihub.txt" file containing credentials
of SciHub account.
If NA (default), the default location inside the package will be used.}
}
\value{
A named vector, containing the selection of \code{s2_prodlist} elements
which were ordered.
Moreover, the vector includes the following attributes:
\itemize{
\item "available" with the elements of \code{s2_prodlist} which were already
available for download,
\item "notordered" with the elements of \code{s2_prodlist} which were not ordered
for any reasons,
\item "path" (only if argument \code{export_prodlist} is not FALSE) with the path of
the json file in which the list of the ordered products was saved.
}
}
\description{
The function orders S2 products from Long Term Archive
(https://scihub.copernicus.eu/userguide/LongTermArchive).
}
\note{
License: GPL 3.0
}
\examples{
\donttest{
# Generate the lists of products
pos <- sf::st_sfc(sf::st_point(c(-57.8815,-51.6954)), crs = 4326)
time_window <- as.Date(c("2018-02-21", "2018-03-20"))
list_safe <- s2_list(spatial_extent = pos, time_interval = time_window)
print(list_safe)
# (at the time the documentation was written, this list was containing 5
# archives already available online and 2 stored in the Long Term Archive)

# Order the products
ordered_prods <- s2_order(list_safe)

# Check in a second time if the product was made available
(order_path <- attr(ordered_prods, "path"))
safe_is_online(order_path)
}
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
