% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ignorelist.R
\name{write_ignorelist}
\alias{write_ignorelist}
\alias{read_ignorelist}
\alias{path_ignorelist}
\alias{clean_ignorelist}
\title{Read / write the ignore list}
\usage{
write_ignorelist(
  pm,
  names_cloudcovered = NULL,
  dates_cloudcovered = NULL,
  names_missing = NULL,
  param_list = NULL
)

read_ignorelist(pm, param_list = NULL)

path_ignorelist(pm)

clean_ignorelist(pm, param_list = NULL)
}
\arguments{
\item{pm}{parameter list (passed by \code{sen2r()}).}

\item{names_cloudcovered}{paths of cloud covered images (passed by \code{sen2r()}).}

\item{dates_cloudcovered}{dates of cloud covered images (passed by \code{sen2r()})
(this is used only if \code{names_cloudcovered} is not specified).}

\item{names_missing}{paths of non produced images (passed by \code{sen2r()}).}

\item{param_list}{path of the parameter file (passed by \code{sen2r()}).}
}
\value{
\code{write_ignorelist()} returns the path of the written TOML file
(invisibly).

\code{read_ignorelist()} returns a list with two vectors:
\itemize{
\item \code{dates_cloudcovered} (dates of cloud covered files);
\item \code{names_missing} (base names of files to be ignored).
}

\code{path_ignorelist()} returns the path in which the TOML file
should be written (basing on processing parameters).

\code{clean_ignorelist()} returns NULL (it is called for its side effects).
}
\description{
Internal functions to read or write the file containing
information about images not to process (because cloud covered or because,
for any reason, they were not produced during previous processing runs).
}
\details{
Sometimes not all the output files are correctly created:
the main reason is the cloud coverage higher than the maximum allowed
value (argument \code{max_mask}), but also some other unexpected reasons could
happen, i.e. because of old name SAFE products which do not include all the tiles.
To prevent to try to create these files every time the function is called
with the same parameter file, the TOML file \code{".ignorelist.txt"} is created
in the directory where output files (or indices, or RGB images) are saved.
With sen2r <= 1.3.3, a different strategy was used: if \code{param_list} is a path,
these lists were saved in two hidden files ( one per file not created
because of cloud coverage, one other for all the other reasons).
To try it again, delete the files/files or set \code{overwrite = TRUE} in \code{sen2r()}).
}
\note{
License: GPL 3.0
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473. DOI:
\href{https://doi.org/10.1016/j.cageo.2020.104473}{10.1016/j.cageo.2020.104473},
URL: \url{http://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2020) \email{luigi@ranghetti.info}
}
