% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol_boot.R
\name{sobol_ci_dummy}
\alias{sobol_ci_dummy}
\title{Bootstrap confidence intervals for the dummy parameter}
\usage{
sobol_ci_dummy(b, type = type, conf = conf)
}
\arguments{
\item{b}{The output of the \code{sobol_dummy} function.}

\item{type}{A vector of character strings representing
the type of intervals required. The value should be any subset
of the values \code{c("norm", "basic", "perc", "bca")}. For more information,
check the function \code{\link{boot.ci}}.}

\item{conf}{A scalar or vector containing the confidence
level(s) of the required interval(s).}
}
\value{
A data table.
}
\description{
It computes bootstrap confidence intervals for the dummy parameter.
}
\examples{
# Define settings:
n <- 100; k <- 8; R <- 10
# Design the sample matrix:
A <- sobol_matrices(n = n, k = k, second = TRUE, third = TRUE)
# Compute the model output:
Y <- sobol_Fun(A)
# Compute the Sobol' indices for the dummy parameter:
s.dummy <- sobol_dummy(Y = Y, params = colnames(data.frame(A)), R = R, n = n)
# Compute the confidence intervals for the dummy parameter:
sobol_ci_dummy(s.dummy, type = "norm", conf = 0.95)
}
\seealso{
\code{\link{boot}}, \code{\link{boot.ci}}.
}
