% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol_boot.R
\name{sobol_replicas}
\alias{sobol_replicas}
\title{Extract bootstrap replicas}
\usage{
sobol_replicas(dt, k, second = FALSE, third = FALSE)
}
\arguments{
\item{dt}{The output of the \code{sobol_indices} function.}

\item{k}{The number of parameters.}

\item{second}{Logical. If \code{second = TRUE}, it computes the confidence
intervals for second-order indices. Default is \code{second = FALSE}.}

\item{third}{Logical. If \code{third = TRUE}, it computes the confidence
intervals for third-order indices. Default is \code{third = FALSE}.}
}
\value{
A \code{data.table}.
}
\description{
It creates a \code{data.table} with all the bootstrap replicas.
}
\examples{
# Define settings:
n <- 100; k <- 8; R <- 100
# Design the sample matrix:
A <- sobol_matrices(n = n, k = k, second = TRUE, third = TRUE)
# Compute the model output:
Y <- sobol_Fun(A)
# Compute the Sobol' indices:
\donttest{sens <- sobol_indices(Y = Y, params = colnames(data.frame(A)),
R = R, n = n, parallel = "no", ncpus = 1, second = TRUE, third = TRUE)
# Extract the bootstrap replicas up to third-order
replicas <- sobol_replicas(dt = sens, k = k, second = TRUE, third = TRUE)}
}
