% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentiment_by.R
\name{sentiment_by}
\alias{sentiment_by}
\title{Polarity Score (Sentiment Analysis) By Groups}
\usage{
sentiment_by(text.var, by = NULL, group.names, ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{by}{The grouping variable(s).  Default \code{NULL} uses the original
row/element indices; if you used a column of 12 rows for \code{text.var}
these 12 rows will be used as the grouping variable.  Also takes a single
grouping variable or a list of 1 or more grouping variables.}

\item{group.names}{A vector of names that corresponds to group.  Generally
for internal use.}

\item{\ldots}{Other arguments passed to \code{\link[sentimentr]{sentiment}}.}
}
\value{
Returns a \pkg{data.table} with grouping variables plus:
\itemize{
  \item  element_id - The id number of the original vector passed to \code{sentiment}
  \item  sentence_id - The id number of the sentences within each \code{element_id}
  \item  word_count - Word count \code{\link[base]{sum}}med by grouping variable
  \item  sd - Standard deviation (\code{\link[stats]{sd}}) of the sentiment/polarity score by grouping variable
  \item  ave_sentiment - Sentiment/polarity score \code{\link[base]{mean}} average by grouping variable
}
}
\description{
Approximate the sentiment (polarity) of text by grouping variable(s).
}
\seealso{
Other sentiment.functions: \code{\link{sentiment}}
}
\keyword{group}
\keyword{polarity,}
\keyword{sentiment,}

