% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_sentiment_terms.R
\name{extract_sentiment_terms}
\alias{extract_sentiment_terms}
\title{Extract Sentiment Words}
\usage{
extract_sentiment_terms(text.var,
  polarity_dt = lexicon::hash_sentiment_jockers_rinker, hyphen = "",
  ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{polarity_dt}{A \pkg{data.table} of positive/negative words and
weights with x and y as column names.}

\item{hyphen}{The character string to replace hyphens with.  Default replaces
with nothing so 'sugar-free' becomes 'sugarfree'.  Setting \code{hyphen = " "}
would result in a space between words (e.g., 'sugar free').}

\item{\ldots}{Ignored.}
}
\value{
Returns a \pkg{data.table} with columns of positive and 
negative terms.
}
\description{
Extract the sentiment words from a text.
}
\examples{
library(data.table)
set.seed(10)
x <- get_sentences(sample(hu_liu_cannon_reviews[[2]], 1000, TRUE))
sentiment(x)

pol_words <- extract_sentiment_terms(x)
pol_words
pol_words$sentence
pol_words$neutral
data.table::as.data.table(pol_words)

attributes(extract_sentiment_terms(x))$counts
attributes(extract_sentiment_terms(x))$elements
}
